/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import text.Format;

/**
 *
 * @author mtomono
 */
public class RingBuffer<T> extends AbstractList<T> {
    ArrayList<T> body;
    int index;
    int limit;
    
    public RingBuffer(ArrayList<T> body) {
        this.body = body;
        this.index = 0;
    }
    
    public RingBuffer(T... body) {
        this(new ArrayList<>(c.<T>a2l(body)));
    }
    
    public RingBuffer() {
        this.body = new ArrayList();
        this.index = 0;
    }
    
    public void append(T... obj) {
        this.body.addAll(c.<T>a2l(obj));
    }
    
    public T push(T obj) {
        assert !this.body.isEmpty();
        T retval = this.body.get(index);
        this.body.set(index, obj);
        index = at(1);
        return retval;
    }
    
    protected int at(int arg0) {
        return this.body.isEmpty() ? -1 : (index + arg0) % this.body.size();
    }
    
    @Override
    public int size() {
        return body.size();
    }

    @Override
    public boolean add(T arg0) {
        if (index == 0) {
            append(arg0);
        } else {
            this.body.add(at(0), arg0);
            index++;
        }
        return true;
    }
    
    @Override
    public void add(int at, T arg0) {
        if (at > size())
            throw new IndexOutOfBoundsException();
        if (at == size()) {
            add(arg0);
            return;
        }
        int onList = at(at);
        this.body.add(onList, arg0);
        if (onList < index) {
            index++;
        }
    }

    @Override
    public boolean remove(Object arg0) {
        if (this.body.isEmpty())
            return false;
        int at = this.indexOf(arg0);
        if (at == -1) {
            return false;
        }
        remove(at);
        return true;
    }
    
    @Override
    public T remove(int at) {
        if (at >= size()) {
            throw new IndexOutOfBoundsException();
        }
        int onList = at(at);
        T retval = this.body.remove(onList);
        if (onList < index) {
            --index;
        }
        return retval;
    }
    
    @Override
    public T get(int arg0) {
        if (arg0 >= size())
            throw new NoSuchElementException("RingBuffer#get() refered to");
        return this.body.get(at(arg0));
    }

    @Override
    public T set(int arg0, T arg1) {
        return this.body.set(at(arg0), arg1);
    }

    @Override
    public String toString() {
        return Format.collection(this);
    }
}
