/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection.view;
import mapping.Mapping;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import text.Format;

/**
 *
 * @author mtomono
 */
abstract public class ListView<T> extends AbstractList<T> {
    List<T> body;
    boolean closed;
    
    abstract public int at(int index);
    
    public ListView(List<T> body) {
        this.body = body;
        this.closed = false;
    }
    
    public boolean isReady(int index) {
        if (closed)
            return false;
        if (body instanceof ListView)
            return ((ListView)body).isReady(at(index));
        else
            return 0 <= at(index) && at(index) < this.body.size();
    }
    
    public void close() {
        this.closed = true;
    }
    
    @Override
    public T get(int index) {
        return body.get(at(index));
    }
    
    @Override
    public int size() {
        return this.body.size();
    }
    
    @Override
    public String toString() {
        return Format.collection(this);
    }
}
