/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection.view;
import java.util.List;
import java.util.NoSuchElementException;

/**
 *
 * @author mtomono
 */
public class ScopedView<T> extends ListView<T> {
    int size;
    public ScopedView(List<T> body, int size) {
        super(body);
        this.size = size;
    }
    
    @Override
    public int at(int index) {
        if (index >= size)
            throw new NoSuchElementException("ScopedView : index out of range");
        return index;
    }
    
    @Override
    public int size() {
        return body.size() < size ? body.size() : size;
    }
}
