/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package container;

import container.Container;
import mapping.order.Compare;
import mapping.order.Order;

/**
 * Container Compare which returns false when norm is not ready.
 * @author mtomono
 */
public class CCX<T extends Comparable<T>> extends CC<T> {
    public CCX(Compare<T> body, Container<T> norm, Order<T> order) {
        super(body, norm, order);
    }
    
    public CCX(Compare<T> body, Container<T> norm) {
        super(body, norm);
    }
    
    @Override
    protected boolean ifNotReady() {
        return isReady();
    }
    
    @Override
    public String toString() {
        return "X" + body.toString() + norm.toString();
    }
}
