/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package context;

import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class BindVariable<T> implements Mapping<Context<?>, T> {
    String name;
    public BindVariable(String name) {
        this.name = name;
    }
    
    @Override
    public T of(Context<?> target) {
        return (T)target.getValues().get(name);
    }
    
    public void set(Context<?> target, T value) {
        target.getValues().put(name, value);
    }

    @Override
    public boolean isReady(Context<?> target) {
        return target.hasValues() && target.getValues().containsKey(name);
    }
    
}
