/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package context;

import collection.view.OffsetIterator;
import collection.view.OffsetView;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import orderedSet.Range;
import parser.ParseResult;
import parser.reduce.Reduce;

/**
 * stands for Iterator Context
 * @author mtomono
 */
public class IContext<T> extends Context<T> implements Iterator<T> {
    Iterator<T> body;
    public OffsetView<T> offset;
    LinkedList<ParseResult> stack;

    public IContext(List<T> body) {
        this(new OffsetView(body, -1)); // next()するとget(0)できるようにするため
    }
    
    public IContext(OffsetView<T> view) {
        this(new OffsetIterator(view), view);
    }
    
    public IContext(Iterator<T> body, OffsetView<T> view) {
        super(view);
        this.offset = view;
        this.body = body;
        this.stack = new LinkedList<>();
    }
    
    public LinkedList<ParseResult> stack() {
        return stack;
    }
    
    @Override
    public IContext<T> setValues(Map<String, ?> values) {
        return (IContext<T>)super.setValues(values);
    }
    
    public int save() {
        return offset.getOffset();
    }
    
    public void load(int position) {
        offset.setOffset(position);
    }
    
    public int getNextPosition() {
        return offset.getOffset() + 1;
    }

    @Override
    public boolean hasNext() {
        return body.hasNext();
    }

    @Override
    public T next() {
        T retval = body.next();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
