/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package debugging;

import java.io.PrintStream;
import mapping.Mapping;
import mapping.WMapping;

/**
 *
 * @author mtomono
 */
public class Monitor<IN> extends WMapping<IN, IN> {
    Mapping<? super IN, String> toString;
    PrintStream out;
    
    public Monitor() {
        this(System.out);
    }
    
    public Monitor(PrintStream out) {
        this(new ToString(), out);
    }
    
    public Monitor(Mapping<? super IN, String> toString, PrintStream out) {
        this.toString = toString;
        this.out = out;
    }
    
    @Override
    public IN of(IN target) {
        this.out.println(toString.of(target));
        return target;
    }
    
}
