/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package debugging;

import java.io.PrintStream;
import java.util.Iterator;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class MonitorIterator<T> implements Iterator<T> {
    PrintStream out;
    Mapping<? super T, String> toString;
    Iterator<T> body;
    
    public MonitorIterator(Iterator<T> body) {
        this(body, System.out);
    }
    
    public MonitorIterator(Iterator<T> body, PrintStream out) {
        this(body, new ToString(), out);
    }
    
    public MonitorIterator(Iterator<T> body, Mapping<? super T, String> toString, PrintStream out) {
        this.out = out;
        this.toString = toString;
        this.body = body;
    }
    
    @Override
    public boolean hasNext() {
        boolean retval = body.hasNext();
        out.print("hasNext:" + (retval?'T':'F') + " ");
        return retval;
    }

    @Override
    public T next() {
        T retval = body.next();
        out.println("next:" + retval);
        return retval;
    }

    @Override
    public void remove() {
        out.println("removed");
        body.remove();
    }
}
