/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class CollectIterator<IN, OUT> implements Iterator<OUT> {
    Iterator<IN> body;
    Mapping<? super IN, ? extends OUT> mapping;
    public CollectIterator(Iterator<? extends IN> body, Mapping<? super IN, ? extends OUT> mapping) {
        this.body = Iterators.selectReady(body, mapping);
        this.mapping = mapping;
    }
    
    @Override
    public boolean hasNext() {
        return body.hasNext();
    }

    @Override
    public OUT next() {
        return mapping.of(body.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
