/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Collections;
import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class ConcatIterator<T> extends AbstractIterator<T> {
    Iterator<Iterator<T>> body;
    Iterator<T> iter;
    
    public ConcatIterator(Iterator<Iterator<T>> body) {
        this.body = body;
        this.iter = Collections.emptyIterator();
    }
    
    @Override
    protected void findNext() {
        while (iter == null) {
            if (body.hasNext()) {
                iter = body.next();
            } else {
                return;
            }
        }
        if (iter.hasNext()) {
            nextFound(iter.next());
        } else if (body.hasNext()) {
            iter = body.next();
            findNext();
        }
    }
}
