/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/**
 *
 * @author mtomono
 */
public class CyclicIterator {
    public static <T> Iterator<T> c(Iterable<T> body) {
        if (body instanceof RandomAccess) {
            return new CyclicIteratorForArray<>((List<T>)body);
        } else {
            return new CyclicIteratorForIterable<>(body);
        }
    }
    
    public static <T> Iterator<T> c(T[] body) {
        return new CyclicIteratorForArray<>(body);
    }
}
