/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class DivideController<T> {
    Iterator<T> base;
    Mapping<? super T, Integer> counter;
    
    public DivideController(Iterator<T> base, Mapping<? super T, Integer> counter) {
        this.base = base;
        this.counter = counter;
    }
    
    public boolean skip() {
        int count = counter.of(base.next());
        for (int i = 1; i < count; i++)
            base.next();
        return base.hasNext();
    }
    
    public boolean resume() {
        if (!base.hasNext())
            return false;
        skip();
        return base.hasNext();
    }
    
    public boolean hasNext() {
        return base.hasNext();
    }
}
