/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class For<T> extends AbstractIterator<T> {
    T current;
    Mapping<? super T, Boolean> condition;
    Mapping<? super T, ? extends T> inclement;
    
    public For(T initial, Mapping<? super T, Boolean> condition, Mapping<? super T, ? extends T> inclement) {
        this.current = initial;
        this.condition = condition;
        this.inclement = inclement;
    }
    
    @Override
    protected void findNext() {
        if (condition.of(this.current)) {
            nextFound(this.current);
            this.current = this.inclement.of(this.current);
        }
    }
}
