/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class InterCollectIterator<IN, OUT> extends AbstractIterator<OUT> {
    SingleUnreadableIterator<IN> body;
    Mapping<? super IN, ? extends OUT> skip;
    Mapping<? super IN, ? extends OUT> next;
    
    public InterCollectIterator(Iterator<IN> body, Mapping<? super IN, ? extends OUT> skip, Mapping<? super IN, ? extends OUT> next) {
        this.body = new SingleUnreadableIterator<>(body);
        this.skip = skip;
        this.next = next;
    }

    @Override
    protected void findNext() {
        while (body.hasNext()) {
            IN current = body.next();
            if (skip.isReady(current)) {
                body.unread();
                nextFound(skip.of(current));
                return;
            }
            if (next.isReady(current)) {
                nextFound(next.of(current));
                return;
            }
        }
    }
    
}
