/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;
import collection.SizedRingBuffer;
import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class PrefetchedIterator<T> implements Iterator<T> {
    Iterator<T> body;
    SizedRingBuffer<T> prefetched;
    
    public PrefetchedIterator(Iterator<T> body, int depth) {
        this.body = body;
        this.prefetched = new SizedRingBuffer<>(depth);
    }
    
    public int getDepth() {
        return prefetched.getLimit();
    }
    
    public int prefetch(int numberOfPrefetch) {
        for (int i = 0; i < numberOfPrefetch; i++) {
            if (this.body.hasNext()) {
                next();
            } else {
                return i;
            }
        }
        return numberOfPrefetch;
    }
    
    public static <T> PrefetchedIterator<T> createNextReady(Iterator<T> body, int numberOfPrefetch) {
        PrefetchedIterator<T> retval = new PrefetchedIterator(body, numberOfPrefetch + 1);
        retval.prefetch(numberOfPrefetch);
        return retval;
    }
    
    public SizedRingBuffer<T> pre() {
        return prefetched;
    }
    
    @Override
    public boolean hasNext() {
        return this.body.hasNext();
    }

    @Override
    public T next() {
        T retval = this.body.next();
        this.prefetched.push(retval);
        return retval;
    }
    
    public void load(T o) {
        this.prefetched.push(o);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
