/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import context.IContext;
import java.util.Iterator;
import java.util.Map;

/**
 *
 * @author mtomono
 */
public class ScopedIContextIterator<T> implements Iterator<IContext<T>> {
    ScopedIterator<T> body;
    Map<String, ?> values;
    
    public ScopedIContextIterator(Iterator<T> body, int fore, int pre) {
        this(new ScopedIterator<>(body, fore, pre));
    }
    
    public ScopedIContextIterator(ScopedIterator<T> body) {
        this.body = body;
    }
    
    public ScopedIContextIterator<T> setValues(Map<String, ?> values) {
        this.values = values;
        return this;
    }

    @Override
    public boolean hasNext() {
        return body.hasNext();
    }

    @Override
    public IContext<T> next() {
        body.next();
        return new IContext<>(this.body.scope()).setValues(values);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
