/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import collection.view.LastAlignedView;
import collection.view.ListView;
import collection.view.OffsetIterator;
import collection.view.OffsetView;
import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class ScopedIterator<T> implements Iterator<T> {
    PrefetchedIterator<T> body;
    OffsetView<T> view;
    OffsetIterator<T> subIter;
    
    public ScopedIterator(Iterator<T> body, int fore, int pre) {
        this.body = new PrefetchedIterator<>(body, pre + 1 + fore); // 1 for NOW
        this.view = new OffsetView<>(new LastAlignedView<>(this.body.pre(), this.body.prefetch(fore) + 1));
        this.subIter = new OffsetIterator<>(this.view);
    }
    
    public ListView<T> scope() {
        return this.view;
    }
    
    @Override
    public boolean hasNext() {
        return body.hasNext() || subIter.hasNext();
    }

    @Override
    public T next() {
        if (body.hasNext()) 
            body.next();
        else
            subIter.next();
        return view.get(0);
    }

    public void load(T o) {
        body.load(o);
    }
    
    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
