/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class SelectIterator<T> extends AbstractIterator<T> {
    Mapping<? super T, Boolean> intension;
    Iterator<? extends T> body;
    public SelectIterator(Iterator<? extends T> body, Mapping<? super T, Boolean> intension) {
        this.body = body;
        this.intension = intension;
    }
    @Override
    protected void findNext() {
        while (body.hasNext()) {
            T candidate = body.next();
            if (intension.of(candidate)) {
                nextFound(candidate);
                return;
            }
        }
    }
}
