/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class SingleUnreadableIterator<T> extends UnreadableIterator<T> {
    Iterator<T> body;
    T current;
    boolean buffered;
    boolean skip;
    
    public SingleUnreadableIterator(Iterator<T> body) {
        this.body = body;
        this.skip = false;
        this.buffered = false;
    }

    @Override
    public boolean unread() {
        if (!buffered || skip)
            return false;
        this.skip = true;
        return true;
    }
    
    @Override
    public boolean hasNext() {
        return skip || body.hasNext();
    }

    @Override
    public T next() {
        buffered = true;
        if (!skip)
            current = body.next();
        skip = false;
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
