/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class SingletonIterator<T> implements Iterator<T> {
    boolean hasNext;
    T body;
    public SingletonIterator(T body) {
        refresh(body);
    }
    
    public final void refresh(T body) {
        this.hasNext = true;
        this.body = body;
    }
    
    @Override
    public boolean hasNext() {
        return hasNext;
    }

    @Override
    public T next() {
        hasNext = false;
        return body;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
