/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;

/**
 *
 * @author mtomono
 */
abstract public class VariableIterator<T> implements Iterator<T> {
    T current;
    boolean currentReady;
    Iterator<T> base;
    
    public VariableIterator() {
        this.base = null;
        this.currentReady = false;
    }
    
    public VariableIterator<T> wrap(Iterator<T> base) {
        this.base = base;
        return this;
    }
    
    public VariableIterator<T> cascade(VariableIterator<T> base) {
        if (base.hasNext())
            base.next();
        return wrap(base);
    }
    
    public T v() {
        assert currentReady;
        return current;
    }
    
    @Override
    public boolean hasNext() {
        assert base != null;
        return this.base.hasNext();
    }
    
    T push() {
        T retval = this.current;
        this.current = this.base.next();
        this.currentReady = true;
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
