/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import iterator.DivideController;
import iterator.DividedIterator;
import iterator.UnreadableIterator;
import iterator.UntilIterator;
import mapping.Const;
import mapping.Mapping;
import mapping.WMapping;

/**
 *
 * @author mtomono
 */
public class Divided<T> extends WMapping<UnreadableIterator<T>, DividedIterator<T>> {
    Mapping<? super T, Boolean> terminator;
    
    public Divided(Mapping<? super T, Boolean> divided) {
        this.terminator = divided;
    }
    
    @Override
    public DividedIterator<T> of(UnreadableIterator<T> target) {
        UntilIterator<T> until = new UntilIterator<>(target, terminator);
        return new DividedIterator(until, new DivideController<>(target, new Const<>(1)));
    }
}
