/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import context.Context;
import iterator.CollectIterator;
import iterator.ScopedContextIterator;
import java.util.Iterator;
import java.util.List;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class Inject<IN, OUT> extends Recursive<IN, OUT>  {

    public Inject(Mapping<? super List<IN>, ? extends OUT> inject, OUT... init) {
        super(inject, init);
    }
    
    public Inject(int depth, Mapping<? super Context<IN>, ? extends OUT> inject, OUT... init) {
        super(depth, inject, init);
    }
    
    @Override
    public Iterator<OUT> collect(ScopedContextIterator<IN> context, Mapping<? super Context<IN>, ? extends OUT> inject) {
        return new CollectIterator<>(context, inject);
    }
}
