/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import iterator.ScopedIContextIterator;
import iterator.SingleUnreadableIterator;
import iterator.SkipIterator;
import java.util.Iterator;
import java.util.Map;
import mapping.WMapping;
import parser.Grammar;

/**
 *
 * @author mtomono
 */
public class PatternSkip<T> extends WMapping<Iterator<T>, Iterator<T>> {
    Grammar<T> divide;
    int fore;
    int pre;
    Map<String, ?> values;
    
    public PatternSkip(Grammar<T> divide, int fore, int pre, Map<String, ?> values) {
        this(divide, fore, pre);
        this.values = values;
    }
    
    public PatternSkip(Grammar<T> divide, int fore, int pre) {
        this.divide = divide;
        this.fore = fore;
        this.pre = pre;
        this.values = null;
    }
    
    @Override
    public Iterator<T> of(Iterator<T> target) {
        return new SkipIterator<>(new PatternDivided<>(divide).of(new SingleUnreadableIterator<>(new ScopedIContextIterator<>(target, fore, pre).setValues(values))));
    }
}
