/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import collection.At;
import collection.c;
import context.BindVariable;
import context.Context;
import iterator.ScopedContextIterator;
import iterator.ScopedIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mapping.Mapping;
import mapping.WMapping;
import mapping.o;

/**
 *
 * @author mtomono
 */
abstract public class Recursive<IN, OUT> extends WMapping<Iterator<IN>, ScopedIterator<OUT>> {
    static String finalContextName = "=======FNC****ResultIterView=";
    Mapping<? super Context<IN>, ? extends OUT> inject;
    int depth;
    OUT[] init;
    
    public Recursive(int depth, Mapping<? super Context<IN>, ? extends OUT> inject, OUT... init) {
        this.inject = inject;
        this.depth = depth;
        this.init = init;
    }
    
    public Recursive(Mapping<? super List<IN>, ? extends OUT> inject, OUT... init) {
        this(1, new InjectAdapter<>(inject, finalContextName), init);
    }
    
    @Override
    public ScopedIterator<OUT> of(Iterator<IN> sourceIter) {
        ScopedContextIterator<IN> contextIter = new ScopedContextIterator<>(sourceIter, 0, depth);
        Iterator<OUT> resultIter = this.collect(contextIter, inject);
        ScopedIterator<OUT> resultScope = new ScopedIterator(resultIter, 0, depth);
        for (int i = 0; i < init.length; i++) {
            resultScope.load(init[i]);
        }
        Map<String, Object> values = new TreeMap<>();
        values.put(finalContextName, resultScope.scope());
        contextIter.setValues(values);
        return resultScope;
    }
    
    abstract public Iterator<OUT> collect(ScopedContextIterator<IN> context, Mapping<? super Context<IN>, ? extends OUT> inject);
    
    static class InjectAdapter<IN, OUT> implements Mapping<Context<IN>, OUT> {

        Mapping<? super List<IN>, ? extends OUT> body;
        Mapping<Context<?>, IN> pre;
        Mapping<List<IN>, IN> now;

        public InjectAdapter(Mapping<? super List<IN>, ? extends OUT> body, String name) {
            this.body = body;
            this.pre = Recursive.<IN>pre();
            this.now = Recursive.<IN>now();
        }

        @Override
        public OUT of(Context<IN> target) {
            return body.of(c.a2l(pre.of(target), now.of(target)));
        }

        @Override
        public boolean isReady(Context<IN> target) {
            return body.isReady(c.a2l(pre.of(target), now.of(target)));
        }

    }
    
    static public <T> Mapping<Context<?>, T> pre(int at) {
        return new o<>(At.<T>c(at + 1), new BindVariable<List<T>>(finalContextName));
    }

    static public <T> Mapping<Context<?>, T> pre() {
        return iterator.mapping.Recursive.<T>pre(-1);
    }

    static public <T> Mapping<List<T>, T> now() {
        return At.<T>c(0);
    }
}
