/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping;

import collection.c;
import iterator.driver.ForAll;
import text.Format;

/**
 *
 * @author mtomono
 */
public class And<T> implements Mapping<T, Boolean> {
    Iterable<Mapping<? super T, Boolean>> body;

    @SafeVarargs
    public And(Mapping<? super T, Boolean>... body) {
        this(c.a2l(body));
    }
    
    public And(Iterable<Mapping<? super T, Boolean>> body) {
        this.body = body;
    }
    
    @Override
    public Boolean of(T target) {
        return new ForAll<>(new Of<T, Boolean>(target)).of(body.iterator());
    }
    
    @Override
    public String toString() {
       return Format.concat(this.body, "&", null);
    }

    @Override
    public boolean isReady(T target) {
        return new ForAll<>(new IsReady<>(new Of<>(target))).of(body.iterator());
    }
}
