/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping;

import collection.c;
import iterator.driver.ForAll;
import iterator.driver.IfAny;
import text.Format;

/**
 *
 * @author mtomono
 */
public class Or<T> implements Mapping<T, Boolean> {
    Iterable<Mapping<? super T, Boolean>> body;
    
    @SafeVarargs
    public Or(Mapping<? super T, Boolean>... body) {
        this(c.a2l(body));
    }
    
    public Or(Iterable<Mapping<? super T, Boolean>> body) {
        this.body = body;
    }
    @Override
    public Boolean of(T target) {
        return new IfAny<>(new Of<T, Boolean>(target)).of(body.iterator());
    }

    @Override
    public String toString() {
        return Format.concat(this.body, "|", null);
    }

    @Override
    public boolean isReady(T target) {
        return new ForAll<>(new IsReady<>(new Of<>(target))).of(body.iterator());
    }
}
