/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping;

/**
 *
 * @author mtomono
 */
public class Where<VALUE, CHECKED> implements Mapping<VALUE, Boolean> {
    Mapping<? super VALUE, ? extends CHECKED> mapping;
    Mapping<? super CHECKED, Boolean> intension;

    public Where(Mapping<? super CHECKED, Boolean> intension, Mapping<? super VALUE, ? extends CHECKED> mapping) {
        this.mapping = mapping;
        this.intension = intension;
    }
    @Override
    public Boolean of(VALUE target) {
        return intension.of(mapping.of(target));
    }
    
    @Override
    public String toString() {
        return "(" + mapping.toString() + ":" + intension.toString() + ")";
    }

    @Override
    public boolean isReady(VALUE target) {
        return mapping.isReady(target) && intension.isReady(mapping.of(target));
    }
}
