/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping.order;

import mapping.order.Default;
import mapping.Mapping;
import iterator.SimpleInject;
import java.util.Comparator;
import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class Max<T> extends SimpleInject<T, T> implements Mapping<Iterator<T>, T>{
    Comparator<T> c;
    
    public Max() {
        c = Default.comparator;
    }
    
    public Max(Comparator<T> c) {
        this.c = c;
    }
    
    @Override
    protected T into(T result, T in) {
        return this.c.compare(result, in) < 0 ? in : result;
    }

    @Override
    public T of(Iterator<T> iter) {
        return exec(iter.next(), iter);
    }
    
    @Override
    public boolean isReady(Iterator<T> target) {
        return target.hasNext();
    }
}
