/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping.reflection;

import java.lang.reflect.InvocationTargetException;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public abstract class Reflection<IN, OUT> implements Mapping<IN, OUT> {
    String name;
    public Reflection(String name) {
        this.name = name;
    }
    
    abstract public OUT value(IN target) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException, InstantiationException;

    @Override
    public OUT of(IN target) {
        try {
            return value(target);
        } catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | ClassNotFoundException | InstantiationException e) {
            throw new RuntimeException("Reflection failed to access member(" + name +")", e);
        }
    }

    @Override
    public String toString() {
        return "x." + name;
    }
}
