/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

/**
 *
 * @author mtomono
 */
public class EmptyRange<T extends Comparable<T>> extends Range<T> {
    public EmptyRange() {
        super();
    }
    
    @Override
    public Range clone() {
        return this;
    }
    
    @Override
    public boolean equals(Object o) {
        return o instanceof EmptyRange;
    }
    
    @Override
    public int hashCode() {
        int hash = 7;
        return hash;
    }
    
    @Override
    public T getStart() {
        throw new NotApplicableException("EmptyFragment does not have start");
    }
      
    @Override
    public T getEnd() {
        throw new NotApplicableException("EmptyFragment does not have end");
    }
    
    @Override
    public boolean doesContain(T value) {
        return false;
    }
    
    @Override
    public boolean isUpperThan(T value) {
        return true;
    }
    
    @Override
    public boolean isUpperThan(Range<T> another) {
        return true;
    }
    
    @Override
    public boolean isLowerThan(T value) {
        return true;
    }
    
    @Override
    public boolean isLowerThan(Range<T> another) {
        return true;
    }
    
    @Override
    public boolean doesOverlap(Range<T> another) {
        return false;
    }
    
    @Override
    public boolean doesContain(Range<T> another) {
        return another instanceof EmptyRange;
    }
    
    @Override
    public boolean doesAdjoin(Range<T> another) {
        return false;
    }
    
    @Override
    public boolean doesAdjoinAtStart(Range<T> another) {
        return false;
    }
    
    @Override
    public boolean doesAdjoinAtEnd(Range<T> another) {
        return false;
    }
    
    @Override
    public Range<T> intersect(Range<T> another) {
        return this;
    }
    
    @Override
    public Range<T> cover(Range<T> another) {
        return another;
    }
    
    @Override
    public Range<T> getUpper(T value) {
        return this;
    }
    
    @Override
    public Range<T> getUpper(Range<T> another) {
        return this;
    }
    
    @Override
    public Range<T> getLower(T value) {
        return this;
    }
    
    @Override
    public Range<T> getLower(Range<T> another) {
        return this;
    }
    
    @Override
    public String toString() {
        return "EmptyFragment";
    }
}
