/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;
import iterator.MultiUnreadableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mapping.order.Default;
import mapping.order.Order;
import text.Format;

/**
 *
 * @author mtomono
 */
public class RangeSet<T extends Comparable<T>> {
    List<Range<T>> elements;
   
    public RangeSet() {
        this.elements = Collections.<Range<T>>emptyList();
    }
    
    public RangeSet(Range<T> range) {
        this.elements = Collections.<Range<T>>singletonList(range);
    }
    
    public RangeSet(List<Range<T>> elements) {
        this.elements = elements;
    }
    
    public RangeSet(Order<T> order, T... range) {
        if (range.length == 0) {
            this.elements = Collections.<Range<T>>emptyList();
        } else if (range.length % 2 != 0) {
            throw new RuntimeException("Range(T...) illegal number of parameters");
        } else {
            elements = new ArrayList<>(range.length / 2);
            for (int i = 0; i < range.length; i += 2) {
                elements.add(new Range<>(range[i], range[i+1], order));
            }
        }
    }
    
    public RangeSet(T... range) {
        this(Default.order, range);
    }
    
    public boolean isEmpty() {
        return elements.isEmpty();
    }
    
    public List<Range<T>> toFragments() {
        return elements;
    }
    
    public RangeSet<T> intersect(RangeSet<T> another) {
        List<Range<T>> retval = new ArrayList<>();
        MultiUnreadableIterator<Range<T>> thisIter = new MultiUnreadableIterator<>(elements.iterator(), 2);
        Iterator<Range<T>> anotherIter = another.elements.iterator();
        Range r = null;
        while (anotherIter.hasNext()) {
            r = anotherIter.next();
            intersectUnderRange(retval, thisIter, r);
            intersectAroundRange(retval, thisIter, r);
        }
        intersectOverRange(retval, thisIter, r);
        return new RangeSet<>(retval);
    }
    

    private void intersectUnderRange(List<Range<T>> elements, MultiUnreadableIterator<Range<T>> iter, Range<T> target) {
        while (iter.hasNext()) {
            Range<T> r = iter.next();
            if (r.isLowerThan(target)) {
                continue;
            }
            iter.unread();
            return;
        }
    }
    
    private void intersectAroundRange(List<Range<T>> elements, MultiUnreadableIterator<Range<T>> iter, Range<T> target) {
        if (!iter.hasNext())
            return;
        Range<T> r = null;
        while (iter.hasNext()) {
            r = iter.next();
            if (r.doesOverlap(target))
                elements.add(target.intersect(r));
            else {
                iter.unread();
                break;
            }
        }
        if (target.isLowerThan(r.end))
            iter.unread();
    }
    
    private void intersectOverRange(List<Range<T>> elements, MultiUnreadableIterator<Range<T>> iter, Range<T> range) {
    }
    
    public RangeSet<T> negate(Range<T> target) {
        List<Range<T>> retval = new ArrayList<>();
        MultiUnreadableIterator<Range<T>> thisIter = new MultiUnreadableIterator<>(
                elements.iterator(), 2);
        negateUnderRange(retval, thisIter, target);
        negateAroundRange(retval, thisIter, target);
        negateOverRange(retval, thisIter, target);
        return new RangeSet<>(retval);
    }
    
    private void negateUnderRange(List<Range<T>> elements, MultiUnreadableIterator<Range<T>> iter, Range<T> target) {
        while (iter.hasNext()) {
            Range<T> r = iter.next();
            if (r.isLowerThan(target)) {
                continue;
            }
            iter.unread();
            return;
        }
    }
    
    private void negateAroundRange(List<Range<T>> elements, MultiUnreadableIterator<Range<T>> iter, Range<T> target) {
        if (iter.hasNext()) {
            Range<T> r = iter.next();
            if (target.isLowerThan(r.start)) {
                elements.add(target.clone());
                iter.unread();
                return;
            }
            if (target.doesContain(r.start) && r.isUpperThan(target.start))
                    elements.add(target.getLower(r));
            if (target.doesContain(r.end) && r.isLowerThan(target.end))
                negateAroundRange(elements, iter, target.getUpper(r));
        } else {
            elements.add(target.clone());
        }
    }
    
    private void negateOverRange(List<Range<T>> elements, MultiUnreadableIterator<Range<T>> iter, Range<T> target) {
    }
    
    public RangeSet<T> mask(RangeSet<T> another) {
        return this.intersect(another.negate(this.cover()));
    }
    
    public Range<T> cover() {
        return elements.get(0).cover(elements.get(elements.size() - 1));
    }
    
    public RangeSet<T> union(RangeSet<T> another) {
        Range<T> whole = cover().cover(another.cover());
        RangeSet<T> negative = this.negate(whole).mask(another);
        return negative.negate(whole);
    }
    
    @Override
    public String toString() {
        return Format.concat(elements, ",", "");
    }
}
