/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import collection.c;
import context.IContext;
import java.util.List;
import text.Format;

/**
 *
 * @author mtomono
 */
public class Or<T> extends Grammar<T> {
    List<Grammar<T>> body;
    public Or(Grammar... body) {
        this.body = c.<Grammar<T>>a2l(body);
    }
    
    @Override
    public boolean match(IContext<T> target) {
        for (Grammar g : this.body) {
            if (g.parse(target)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String bodyToString() {
        return Format.concat(this.body, "||", "()");
    }
}