/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import context.IContext;
import java.util.List;
import mapping.Mapping;
import mapping.WMapping;
import mapping.o;

/**
 *
 * @author mtomono
 */

public class ParseMapping<IN> extends WMapping<IContext<IN>, ParseResult> {
    Parser<IN> parser;
    
    static public <IN, OUT> Mapping<IContext<IN>, List<OUT>> toList(Grammar<IN> grammar) {
        return new o<>(new Flatten<OUT>(), ParseMapping.<IN>easy(grammar));
    }
    
    static public <IN> ParseMapping easy(Grammar<IN> grammar) {
        return new ParseMapping<>(new EasyParser<>(grammar));
    }
    
    static public <IN> ParseMapping strict(Grammar<IN> grammar) {
        return new ParseMapping<>(new StrictParser<>(grammar));
    }
    
    static public <IN> ParseMapping simple(Grammar<IN> grammar) {
        return new ParseMapping<>(new SimpleParser<>(grammar));
    }
    
    public ParseMapping(Parser<IN> parser) {
        this.parser = parser;
    }

    @Override
    public ParseResult of(IContext<IN> target) {
        return this.parser.parse(target);
    }
}
