/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import context.IContext;
import text.Format;

/**
 *
 * @author mtomono
 */
public class Rep<T> extends Grammar<T> {
    Grammar<T> body;
    int min;
    int max;
    
    public Rep(Grammar<T> body, int min, int max) {
        assert min >= 0;
        assert max >= min;
        this.body = body;
        this.min = min;
        this.max = max;
    }

    public Rep(Grammar<T> body) {
        this(body, 0, Integer.MAX_VALUE);
    }
    
    @Override
    public boolean match(IContext<T> target) {
        for (int i = 0; i < max; i++) {
            if (!body.parse(target)) {
                return i >= min;
            }
        }
        return true;
    }

    @Override
    public String bodyToString() {
        return Format.parenthesis(this.body.bodyToString(), "()") + repExpression();
    }
    
    private String repExpression() {
        if (min == 0 && max == Integer.MAX_VALUE)
            return "*";
        else if (min == 0) 
            return "[," + max +"]";
        else if (max == Integer.MAX_VALUE)
            return "[" + min + ",]";
        else 
            return "[" + min + "," + max +"]";
    }
}
