/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser.reduce;

import context.IContext;
import mapping.Id;
import mapping.Mapping;
import orderedSet.Range;
import parser.Action;
import parser.Grammar;

/**
 *
 * @author mtomono
 */
public class RangeReduce<T> extends LeafReduce  {
    Mapping<? super Range, T> body;
    
    public RangeReduce() {
        this(new Id<T>());
    }
    
    public RangeReduce(Mapping<? super Range, T> body) {
        this.body = body;
    }
    
    @Override
    public Object leaf(IContext<?> context, int start, int end) {
        return body.of(new Range(start, end));
    }

}
