/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser.reduce;

import context.IContext;
import mapping.Id;
import mapping.Mapping;
import parser.Action;
import parser.Grammar;
import parser.ParseResult;

/**
 * Reduce that does not leave a ParseResult. Though this put a ParseResult
 * on the context in init() so that it can remove any intermediate result when it fail()s.
 * Thus I call it transparent.
 * @author mtomono
 */
public class TransparentReduce extends BranchReduce {

    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        ParseResult retval = context.stack().pop();
        retval.setRange(start, end);
        if (!context.stack().isEmpty())
            context.stack().peek().addAll(retval);
    }
}
