/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package text;

import collection.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mapping.Mapping;
import mapping.reflection.Field;

/**
 *
 * @author mtomono
 */
public class Table<T> {
    public static char clip = '\t';
    public static char csv = ',';
    List<Mapping<? super T, ?>> columns;
    char discriminator;
    
    public Table(char discriminator, List<Mapping<? super T, ?>> columns) {
        this.columns = columns;
        this.discriminator = discriminator;
    }
    
    public Table(char discriminator, Mapping<? super T, ?>... columns) {
        this(discriminator, c.a2l(columns));
    }
    
    public Table(char discriminator, String... columns) {
        List<Mapping<? super T, ?>> c = new ArrayList<>();
        for (String n : columns) {
            c.add(new Field(n));
        }
        this.discriminator = discriminator;
        this.columns = c;
    }
    
    public String format(Collection<T> rows) {
        return format(discriminator, rows, columns);
    }
    
    static public <T> String format(char discriminator, Collection<T> rows, List<Mapping<? super T, ?>> columns) {
        String retval = "";
        for (T o : rows) {
            for (Mapping<? super T, ?> mapping : columns) {
                retval += mapping.of(o).toString(); retval += discriminator;
            }
            retval = retval.substring(0, retval.length() - 1);
            retval += '\n';
        }
        return retval;
    }
}
