!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
MODULE sctk_stdin
  !
  IMPLICIT NONE
  !
CONTAINS
!>
!> Read "control" namelist
!>
SUBROUTINE stdin_control()
  !
  USE io_global,  ONLY : ionode, ionode_id
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_bcast
  USE io_files, ONLY : prefix, tmp_dir
  !
  IMPLICIT NONE
  !
  CHARACTER(256) :: outdir
  CHARACTER(256), EXTERNAL :: trimcheck
  NAMELIST /control/ prefix, outdir
  !
  prefix = 'pwscf'
  CALL get_environment_variable('ESPRESSO_TMPDIR', outdir)
  IF(TRIM(outdir) == ' ') outdir = './'
  !
  IF(ionode) THEN
     !
     CALL input_from_file ( )
     READ(5,control,err=100)
     tmp_dir = trimcheck(outdir)
     !
  END IF
  !
  CALL mp_bcast(prefix,  ionode_id, world_comm)
  CALL mp_bcast(tmp_dir, ionode_id, world_comm)
  !
  RETURN
  !
100 CALL errore ('stdin_control', 'reading namelist CONTROL', 0)
  !
END SUBROUTINE stdin_control
!>
!> Read from STDIN for K_el
!>
SUBROUTINE stdin_Kel()
  !
  USE kinds, ONLY : DP
  USE io_global, ONLY : ionode, ionode_id
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_bcast
  USE gvecw, ONLY : ecutwfc
  USE control_ph, ONLY : start_q, last_q
  USE start_k, ONLY : nk1, nk2, nk3
  USE disp,  ONLY : nq1, nq2, nq3
  !
  USE sctk_val, ONLY : laddxc, nmf, nqbz
  !
  IMPLICIT NONE
  !
  NAMELIST /system/ start_q, last_q, nmf, laddxc, ecutwfc, nq1, nq2, nq3
  !
  IF(ionode) THEN
     !
     nmf = 5
     start_q = 1
     last_q = 0
     laddxc = 0
     nq1 = nk1
     nq2 = nk2
     nq3 = nk3
     ecutwfc = 30.0_dp
     !
     READ(*,system,err=100)
     !
     IF(last_q <= 0) last_q = start_q
     !
     WRITE(*,*) "                 q grid : ", nq1, nq2, nq3
     WRITE(*,*) "   # of Matsubara freq. : ", nmf
     WRITE(*,*) "            The first q : ", start_q
     WRITE(*,*) "             The last q : ", last_q
     WRITE(*,*) "                 laddxc : ", laddxc
     WRITE(*,*) "  Cutoff kinetic energy : ", ecutwfc
     !
  END IF
  !
  CALL mp_bcast(nq1,        ionode_id, world_comm )
  CALL mp_bcast(nq2,        ionode_id, world_comm )
  CALL mp_bcast(nq3,        ionode_id, world_comm )
  CALL mp_bcast(start_q,    ionode_id, world_comm )
  CALL mp_bcast(last_q,     ionode_id, world_comm )
  CALL mp_bcast(nmf,        ionode_id, world_comm )
  CALL mp_bcast(laddxc,     ionode_id, world_comm )
  CALL mp_bcast(ecutwfc,    ionode_id, world_comm )
  !
  ! Compute irreducible q grid
  !
  nqbz = nq1 * nq2 * nq3
  CALL q_points()
  !
  RETURN
  !
100 WRITE(*,*) "Stop in stdin. reading namelist file"
  !
  WRITE(*,*) "                 q grid : ", nq1, nq2, nq3
  WRITE(*,*) "   # of Matsubara freq. : ", nmf
  WRITE(*,*) "            The first q : ", start_q
  WRITE(*,*) "             The last q : ", last_q
  WRITE(*,*) "                 laddxc : ", laddxc
  WRITE(*,*) "  Cutoff kinetic energy : ", ecutwfc
  !
  CALL errore ('stdin_Kel', 'reading namelist SYSTEM', 0)
  !
END SUBROUTINE stdin_Kel
!
! Standard input
!
SUBROUTINE stdin_scdft()
  !
  USE kinds, ONLY : DP
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_bcast
  USE io_global, ONLY : ionode, ionode_id
  USE control_flags, ONLY : niter, tr2
  USE input_parameters, ONLY : electron_maxstep, conv_thr
  USE wvfct, ONLY : nbnd
  USE sctk_val, ONLY : beta, emax, emin, fbee, lbee, ne, nmf, nx, xic
  !
  IMPLICIT NONE
  !
  REAL(dp) :: temp
  !
  NAMELIST /system/ temp, fbee, lbee, xic, nmf, nx, ne, emin, emax, &
  &                electron_maxstep, conv_thr
  !
  IF(ionode) THEN
     !
     temp = 0.1_dp
     fbee = 1
     lbee = nbnd
     xic = -1.0_dp
     nmf = 10
     nx = 100
     ne = 50
     emin = 1.0e-7_dp
     emax = 5.0_dp
     electron_maxstep = 100
     conv_thr = 1.0e-15_dp
     !
     READ(*,system,err=100)
     !
     WRITE(*,*) "               Temparature[K] : ", temp
     beta = 157887.0_dp / temp
     WRITE(*,*) "     Inverse temparature[/Ry] : ", beta
     WRITE(*,*) "                    Xi cutoff : ", xic
     WRITE(*,*) "                   First band : ", fbee
     WRITE(*,*) "                    Last band : ", lbee
     WRITE(*,*) "   # of Matsubara frequencies : ", nmf
     WRITE(*,*) "                      # of xi : ", nx
     WRITE(*,*) "       # of energy for QP-DOS : ", ne
     WRITE(*,*) "         Minimum energy scale : ", emin
     WRITE(*,*) "  Max energy for QP-DOS [meV] : ", emax
     WRITE(*,*) '        Convergense threshold : ', conv_thr
     WRITE(*,*) '                 Max itration : ', electron_maxstep
     !
  END IF
  !
  CALL mp_bcast(beta,             ionode_id, world_comm )
  CALL mp_bcast(xic,              ionode_id, world_comm )
  CALL mp_bcast(fbee,             ionode_id, world_comm )
  CALL mp_bcast(lbee,             ionode_id, world_comm )
  CALL mp_bcast(nmf,              ionode_id, world_comm )
  CALL mp_bcast(nx,               ionode_id, world_comm )
  CALL mp_bcast(ne,               ionode_id, world_comm )
  CALL mp_bcast(emin,             ionode_id, world_comm )
  CALL mp_bcast(emax,             ionode_id, world_comm )
  CALL mp_bcast(electron_maxstep, ionode_id, world_comm )
  CALL mp_bcast(conv_thr,         ionode_id, world_comm )
  !
  niter = electron_maxstep
  tr2 = conv_thr
  !
  RETURN
  !
100 WRITE(*,*) "stop. reading namelist file"
  !
  WRITE(*,*) "               Temparature[K] : ", beta
  beta = 157887.0_dp / beta
  WRITE(*,*) "     Inverse temparature[/Ry] : ", beta
  WRITE(*,*) "                    Xi cutoff : ", xic
  WRITE(*,*) "                   First band : ", fbee
  WRITE(*,*) "                    Last band : ", lbee
  WRITE(*,*) "   # of Matsubara frequencies : ", nmf
  WRITE(*,*) "                      # of xi : ", nx
  WRITE(*,*) "       # of energy for QP-DOS : ", ne
  WRITE(*,*) "         Minimum energy scale : ", emin
  WRITE(*,*) "  Max energy for QP-DOS [meV] : ", emax
  WRITE(*,*) '        Convergense threshold : ', conv_thr
  WRITE(*,*) '                 Max itration : ', electron_maxstep
  !
  CALL errore ('stdin_scdft', 'reading namelist SYSTEM', 0)
  !
END SUBROUTINE stdin_scdft
  !
END MODULE sctk_stdin
