#include "stdafx.h"
// FDK includes
#include "Debug.h"
#include "DTX.h"
// App includes
#include "../resource.h"
#include "DTXViewer.h"
#include "CStage.h"
#include "CStagePlay.h"
#include "ActPlayAVI.h"
#include "ActPlayBGA.h"

namespace DTXViewer {
	namespace Stage {
		namespace Play {

static RECT s_rcChips[28] = {
	{ 640,2,651,5 }, { 651,2,662,5 },												// 0:BPM, 1:BPx
	{ 662,2,673,5 }, { 673,2,684,5 }, { 684,2,695,5 }, { 695,2,706,3 },				// 2:HH, 3:SD, 4:BD, 5:HT
	{ 706,2,717,5 }, { 717,2,728,5 }, { 728,2,739,5 },								// 6:LT, 7:FT, 8;CY
	{ 739,2,746,5 },																// 9:FI
	{ 746,2,757,5 }, { 757,2,768,5 }, { 768,2,779,5 },								// 10:BGM, 11:BGA, 12:AVI
	{ 779,2,790,5 }, { 790,2,801,5 }, { 801,2,812,5 }, { 812,2,819,3 },				// 13:R1, 14:G1, 15:B1. 16:W1
	{ 819,2,830,5 }, { 830,2,841,5 }, { 841,2,852,5 }, { 852,2,859,3 },				// 17:R1, 18:G1, 19:B1. 20:W1
	{ 859,2,870,5 }, { 870,2,881,5 }, { 881,2,892,5 }, { 892,2,903,3 }, { 903,2,914,5 },	// 21`25: SE1`5
	{ 879,2,914,5 },																// 26: GuitarOPEN
	{ 914,2,925,5 }																	// 27: LC
};
static RECT s_rcRing  = { 640, 5, 640+12, 5+12 };									// HHO,RD ̗
static RECT s_rcLine  = { 640, 0, 640+244, 1 };										// ߐ
static RECT s_rcSubLine  = { 640, 1, 640+244, 2 };									// 
static RECT s_rcNums[10] = {
	{   0,   0,  18,  31 },	{  18,   0,  36,  31 },	{  36,   0,  54,  31 },	{  54,   0,  72,  31 },	{  72,   0,  90,  31 },
	{   0,  31,  18,  62 },	{  18,  31,  36,  62 },	{  36,  31,  54,  62 },	{  54,  31,  72,  62 },	{  72,  31,  90,  62 }
};
static const int s_n`l0Ato[07[10] = { 1,2,3,4,5,7,6,1,7,0 };

CStagePlay::CStagePlay()
{
	this->strXe[W = _T("t");
	this->stageID = STAGE_PLAY;
	this->phaseID = PHASE_COMMON_ʏ;
	this->bFirstWork = true;
	this->bActivate = false;
}
//
bool CStagePlay::Load( LPCTSTR strFileName )
{
	this->bLoadingv = true;
	this->strFileName = strFileName;

	return true;
}
void CStagePlay::Play( int nPart )
{
	this->bPlayingv = true;
	this->nJnߔԍ = nPart;
	if( this->nJnߔԍ < 0 ) this->nJnߔԍ = 0;
}
void CStagePlay::Stop()
{
	this->structt.bt = false;

	g_DTX.StopAllWaves();
	this->actAVI.Stop();			// AVI ~
	this->actBGA.Stop();			// BGA ~
}
void CStagePlay::SkipStart( double dbJnms )
{
	DTX::Chip* pChip;
	for( pChip = g_DTX.pChip; pChip != NULL; pChip = pChip->next )
	{
		if( pChip->dbTime >= dbJnms )
			break;

		this->ProcessCell( pChip, true );
	}
	this->structt.p݂̃gbvChip = pChip;
}
//
int	 CStagePlay::MainWork()
{
	// ߂l: 0=p, 1=tI, -1=AvI

	// wi`
	RECT rc = { 0, 0, 640, 480 };
	this->sfMap.Draw( 0, 0, &rc );

	if( this->bLoadingv )
	{
		this->bLoadingv = false;
		this->ctNowLoading\.Start( 0, 50, 1, &g_Timer );
		this->phaseID = PHASE_PLAY_LOADING1;
	}

	switch( this->phaseID )
	{
	case PHASE_PLAY_IDLE:
		break;

	case PHASE_PLAY_LOADING1: {
		RECT rcNowLoading = { 640, 17, 640+229, 17+40 };
		this->sfMap.Draw( 176-225/2, 180-41/2, &rcNowLoading );

		this->ctNowLoading\.Step();
		if( this->ctNowLoading\.bIlɒB() )
			this->phaseID = PHASE_PLAY_LOADING2;
		break;
	}
	case PHASE_PLAY_LOADING2:
		if( this->tDTXt@C̓ǂݍ() )
			this->phaseID = PHASE_PLAY_PLAYING1;
		else {
			this->phaseID = PHASE_PLAY_IDLE;
			this->bPlayingv = false;
		}
		break;

	case PHASE_PLAY_PLAYING1:
		if( this->bPlayingv ) {
			this->tĐJn();
			this->phaseID = PHASE_PLAY_PLAYING2;
		}
		break;

	case PHASE_PLAY_PLAYING2:
		if( this->structt.bt )
		{
			// BGÄNA
			{
				if( g_DTX.bUseAVI || g_DTX.bUseBMP || g_DTX.bUseBMPTEX )
				{
					DDBLTFX ddbfx;
					ZeroMemory( &ddbfx, sizeof( DDBLTFX ) );
					ddbfx.dwSize = sizeof( DDBLTFX );
					ddbfx.dwFillColor = 0xFF000000;
					RECT rc = { BGA_X, BGA_Y, BGA_X+BGA_W, BGA_Y+BGA_H };
					g_App.pddsBackBuffer->Blt( &rc, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbfx );
				}
			}
			//
			// `bvis`
			{
				if( this->structt.p݂̃gbvChip == NULL ) {
					this->Stop();
					this->phaseID = PHASE_PLAY_IDLE;
					return 1;	// tI
				}

				// XN[x[dot/ms] Zo
				static const double BPM = 150.0;			// BPM = P߂̒A150 BPM 
				static const double LEN = 264.0;			// LEN = 264 hbg
				static const double s_dbScrollSpeed = 2.0;	// ʃXN[xiŒj
				double dbDotPerMS_D = ( s_dbScrollSpeed * 0.5       ) * ( BPM / 4.0 ) * LEN / 60000.0;
				double dbDotPerMS_G = ( s_dbScrollSpeed * 0.5 * 0.5 ) * ( BPM / 4.0 ) * LEN / 60000.0;
				double dbDotPerMS_B = ( s_dbScrollSpeed * 0.5 * 0.5 ) * ( BPM / 4.0 ) * LEN / 60000.0;

				// gbvZ珇ԂɁAʂɓ邾`B
				for( DTX::Chip* cell = this->structt.p݂̃gbvChip; cell != NULL; cell = cell->next )
				{
					// o[̋[dot] Zo
					cell->nDotFromBarD = (long)( (cell->dbTime - g_Timer.Get() ) * dbDotPerMS_D );	// h֌WȂ
					cell->nDotFromBarG = (long)( (cell->dbTime - g_Timer.Get() ) * dbDotPerMS_G );	// M^[֌W
					cell->nDotFromBarB = (long)( (cell->dbTime - g_Timer.Get() ) * dbDotPerMS_B );	// x[X֌W
				
					if( MIN( MIN( cell->nDotFromBarD, cell->nDotFromBarG ), cell->nDotFromBarB ) > 480 )
						break;	// hAM^[Ax[X̂AԒZʕ傫Ȃ炻ŏIB
				
					// gbvZւ`FbNG
					// ʉ[艺ȂgbvZւiqbgĖȂ܂ւȂjB
					// 邢́AqbgĂȂĂA-400𒴂狭Iɓւi\hj
					if( cell == this->structt.p݂̃gbvChip )
					{
						if( ( cell->nDotFromBarD < -65 && cell->bHit ) || cell->nDotFromBarD < -400 )		// nDotFromBar ̓hłM^[ł
						{
							this->structt.p݂̃gbvChip = this->structt.p݂̃gbvChip->next;
							continue;
						}
					}

					// `lƂɏ
					this->ProcessCell( cell, false );
				}
			}
			//
			// AVI is`
			{
				if( g_DTX.bUseAVI )
					this->actAVI.MainWork( BGA_X, BGA_Y );
			}
			//
			// BGA is`
			{
				if( g_DTX.bUseBMP || g_DTX.bUseBMPTEX )
					this->actBGA.MainWork( BGA_X, BGA_Y );
			}
		}
		break;
	}

	if( g_DirectInput.IsKeyPushDown( DIK_ESCAPE ) )
		return -1;		// AvI

	return 0;
}
bool CStagePlay::tDTXt@C̓ǂݍ()
{
	this->Stop();

	// t
	{
		this->tt();
		g_DTX.Clear();
	}
	//
	// DTX̓ǂݍ
	{
		if( ! g_DTX.Load( this->strFileName ) )
		{
			Debug::Out( _T("DTXt@C̓ǂݍ݂Ɏs܂B(%s)\n"), this->strFileName.c_str() );
			return false;
		}
		g_DTX.LoadBMP();
		g_DTX.LoadAVI();
	}
	//
	// Đx̐ݒ
	{
		g_DTX.SetSpeed( g_DTX.fSpeed );	// #DTXVPLAYSPEED: 
	}
	//
	// EBhE^CguȖ []vɕύX
	{
		TCHAR buf[ 1024 ];
		_stprintf_s( buf, 1024, _T("%s [%s]"), g_DTX.strTitle.c_str(), g_DTX.strArtist.c_str() );
		::SetWindowText( g_App.hWnd, buf );
	}
	//
	return true;
}
void CStagePlay::tĐJn()
{
	this->Stop();

	// ߔԍ nPart ĐJnƍĐJn`bvZo;
	// ĐJn͏ߐ dbTime 擾Bi\̔{̈ʒuɂ͕KIuWFNgiߐjƂOj
	{
		this->structt.dbJnms = INIT_TIME;
		this->structt.p݂̃gbvChip = NULL;

		for( DTX::Chip* cell = g_DTX.pChip; cell != NULL; cell = cell->next )
		{
			if( cell->dwPosition >= (DWORD)( (this->nJnߔԍ+1) * DTX_RESOLVE ) )
			{
				this->structt.dbJnms = cell->dbTime;
				break;
			}
		}
	}
	//
	// tJn
	{
		if( this->structt.dbJnms != INIT_TIME )
		{
			Debug::Out( _T("tJn = %e [ms]\n"), this->structt.dbJnms );

			// ^C}Zbg`Jn
			g_Timer.Reset();
			g_Timer.Set( this->structt.dbJnms );				// ĐJnZbg
			g_DTX.SkipStart( this->structt.dbJnms );			// S`bvɂ dwStartTime ɍĐۂAĐȂK؂ȌɊeĐJ[\ړčĐ
			this->actAVI.SkipStart( this->structt.dbJnms );	// AVI ̉tJn
			this->actBGA.SkipStart( this->structt.dbJnms );	// BGA ̉tJn
			this->SkipStart( this->structt.dbJnms );			// `bv̉tJn(actBGAł邱; ChangeScopê)
			this->structt.bt = true;

			// ܂ Loading Ỏ\̂ŁAł this->phaseID ͂ȂB
		}
	}
}
void CStagePlay::ProcessCell( DTX::Chip* pChip, bool bSkip )
{
	switch( pChip->nChannel )
	{
	// obNR[X
	case 0x01: {

		// `bv`
		if( ! pChip->bHit && ! bSkip )
			this->sfMap.Draw( 146, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[10] );

		// ĂȂΔ
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			pChip->bHit = true;
			if( ! bSkip )
				g_DTX.PlayChip( pChip, 10, DTX_AUTOVOLUME );
		}
		break;
	}
	// BPMύX
	case 0x03: {
		
		// \
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
			this->sfMap.Draw( 2, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[0] );

		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			// \p BPM ̍XV
			this->structt.db݂BPMEfobO\p = pChip->nParam * g_DTX.fSpeed + g_DTX.dbBaseBPM;
			pChip->bHit = true;
		}
		break;
	}
	// BPMύXigj
	case 0x08: {

		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
			this->sfMap.Draw( 14, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[1] );

		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			pChip->bHit = true;
			
			for( DTX::BPM* bc = g_DTX.pBPMLast; bc != NULL; bc = bc->prev )
			{
				if( bc->num == pChip->nRealParam )
				{
					// \p BPM ̍XV
					this->structt.db݂BPMEfobO\p = bc->bpm * g_DTX.fSpeed + g_DTX.dbBaseBPM;
					break;
				}
			}
		}
		break;
	}
	// BGA
	case 0x04: case 0x07: case 0x55: case 0x56: case 0x57: case 0x58: case 0x59: case 0x60: {
	
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
			this->sfMap.Draw( 158, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[11] );

		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			pChip->bHit = true;
			if( bSkip ) break;

			switch( pChip->BGAtype )
			{
			case BGATYPE_BMP: {
				
				if( pChip->pBMP ) 
				{
					// len = 0 Ȃ]̂ݗLBi] 0 łBj
					this->actBGA.Start( pChip->nChannel, pChip->pBMP, NULL,
						pChip->pBMP->pSurface->dwWidth, pChip->pBMP->pSurface->dwHeight, 0, 0,
						0, 0, 0, 0,
						0, 0, 0, 0,
						0.0 );
				}
				break;
			}
			case BGATYPE_BMPTEX: {
				
				if( pChip->pBMPTEX )
				{
					// len = 0 Ȃ]̂ݗLBi] 0 łBj
					this->actBGA.Start( pChip->nChannel, NULL, pChip->pBMPTEX,
						pChip->pBMPTEX->pTexture->dwWidth, pChip->pBMPTEX->pTexture->dwHeight, 0, 0,
						0, 0, 0, 0,
						0, 0, 0, 0,
						0.0 );
				}
				break;
			}
			case BGATYPE_BGA: {
				
				if( pChip->pBGA && ( pChip->pBMP || pChip->pBMPTEX ) )
				{
					// len = 0 Ȃ]̂ݗLBi] 0 łBj
					this->actBGA.Start( pChip->nChannel, pChip->pBMP, pChip->pBMPTEX,
						pChip->pBGA->x2 - pChip->pBGA->x1, pChip->pBGA->y2 - pChip->pBGA->y1, 0, 0, 
						pChip->pBGA->x1, pChip->pBGA->y1, 0, 0,
						pChip->pBGA->ox, pChip->pBGA->oy, 0, 0,
						0.0 );
				}
				break;
			}
			case BGATYPE_BGAPAN: {
				
				if( pChip->pBGAPan && ( pChip->pBMP || pChip->pBMPTEX ) )
				{
					this->actBGA.Start( pChip->nChannel, pChip->pBMP, pChip->pBMPTEX,
						pChip->pBGAPan->sw, pChip->pBGAPan->sh, pChip->pBGAPan->ew, pChip->pBGAPan->eh,
						pChip->pBGAPan->ssx, pChip->pBGAPan->ssy, pChip->pBGAPan->sex, pChip->pBGAPan->sey,
						pChip->pBGAPan->dsx, pChip->pBGAPan->dsy, pChip->pBGAPan->dex, pChip->pBGAPan->dey,
						pChip->dbLong );
                }
				break;
			}
			}
		}
		break;
	}
	// BGAXR[v摜؂ւ
	case 0xC4: case 0xC7: case 0xD5: case 0xD6: case 0xD7: case 0xD8: case 0xD9: case 0xE0: {

		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
			this->sfMap.Draw( 158, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[11] );

		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			pChip->bHit = true;

			if( pChip->BGAtype == BGATYPE_BMP || pChip->BGAtype == BGATYPE_BMPTEX )
			{
				static const int nCh[2][8] = {
					{ 0xC4, 0xC7, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xE0 },
					{ 0x04, 0x07, 0x55, 0x56, 0x57, 0x58, 0x59, 0x60 }
				};
				for( int i = 0; i < 8; i++)
					if( nCh[0][i] == pChip->nChannel )
						this->actBGA.ChangeScope( nCh[1][i], pChip->pBMP, pChip->pBMPTEX );
			}
		}
		break;
	}
	// h`bv
	case 0x11: case 0x12: case 0x13: case 0x14: case 0x15: case 0x16: case 0x17: case 0x18: case 0x19: case 0x1A: {

		int l = s_n`l0Ato[07[ pChip->nChannel - 0x11 ];

		// ĂȂΔ
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) ) {
			if( ! bSkip )
				this->tTEhĐ( pChip, PLAYPART_DRUMS, DTX_AUTOVOLUME );
			pChip->bHit   = true;
		}

		// `bv̕`
		if( ! pChip->bHit && ! bSkip && pChip->bVisible )
		{
			// `bv`
			this->sfMap.Draw( 33+12*l, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[ (pChip->nChannel!=0x1A)? 1+l : 27 ] );

			// HHO,RD̓O`
			if( pChip->nChannel == 0x18 || pChip->nChannel == 0x19 )
				this->sfMap.Draw( 33+12*l, BAR_Y-pChip->nDotFromBarD-5, &s_rcRing );
		}
		break;
	}
	// h`bvisj
	case 0x31: case 0x32: case 0x33: case 0x34: case 0x35: case 0x36: case 0x37: case 0x38: case 0x39: case 0x3A: {
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
			pChip->bHit = true;		// Ȃ
		break;
	}
	// h`bvi󂤂wj
	case 0xB1: case 0xB2: case 0xB3: case 0xB4: case 0xB5: case 0xB6: case 0xB7: case 0xB8: case 0xB9: case 0xBC: {
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
			pChip->bHit = true;		// Ȃ
		break;
	}
	// M^[`bv
	case 0x20: case 0x21: case 0x22: case 0x23: case 0x24: case 0x25: case 0x26: case 0x27: {

		// ĂȂΔ
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarG < 0 ) )
		{
			if( ! bSkip )
				this->tTEhĐ( pChip, PLAYPART_GUITAR, DTX_AUTOVOLUME );
			pChip->bHit = true;
		}

		// `bv̕`
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
		{
			int y = 38 + pChip->nDotFromBarG-1;
			if( y >= 0 && y < 480 )
			{
				if( pChip->nChannel == 0x20 )	// OPEN
					this->sfMap.Draw( 188, y, &s_rcChips[26] );
				else
				{								// RGB
					if( pChip->nChannel & 0x04 ) this->sfMap.Draw( 188,      y, &s_rcChips[13] );
					if( pChip->nChannel & 0x02 ) this->sfMap.Draw( 188+12,   y, &s_rcChips[14] );
					if( pChip->nChannel & 0x01 ) this->sfMap.Draw( 188+12*2, y, &s_rcChips[15] );
				}
			}
		}
		break;
	}		   
	// M^[`bvi󂤂wj
	case 0xBA: {
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarG < 0 ) )
			pChip->bHit = true;		// Ȃ
		break;
	}
	// x[X`bv
	case 0xA0: case 0xA1: case 0xA2: case 0xA3: case 0xA4: case 0xA5: case 0xA6: case 0xA7: {

		// ĂȂΔ
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarB < 0 ) )
		{
			if( ! bSkip )
				this->tTEhĐ( pChip, PLAYPART_BASS, DTX_AUTOVOLUME );
			pChip->bHit = true;
		}

		// `bv̕`
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
		{
			int y = 38 + pChip->nDotFromBarB-1;
			if( y >= 0 && y < 480 )
			{
				if( pChip->nChannel == 0xA0 )	// OPEN
					this->sfMap.Draw( 234, y, &s_rcChips[26] );
				else
				{								// RGB
					if( pChip->nChannel & 0x04 ) this->sfMap.Draw( 234,      y, &s_rcChips[17] );
					if( pChip->nChannel & 0x02 ) this->sfMap.Draw( 234+12,   y, &s_rcChips[18] );
					if( pChip->nChannel & 0x01 ) this->sfMap.Draw( 234+12*2, y, &s_rcChips[19] );
				}
			}
		}
		break;
	}
	// x[X`bvi󂤂wj
	case 0xBB: {
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarB < 0 ) )
			pChip->bHit = true;		// Ȃ
		break;
	}
	// M^[Wiling
	case 0x28: {
		// qbgĂȂ΃qbg
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarG < 0 ) )
			pChip->bHit = true;

		// `bv`
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
			this->sfMap.Draw( 224, 38+pChip->nDotFromBarG, &s_rcChips[16] );
		break;
	}
	// x[XWiling
	case 0xA8: {
		// qbgĂȂ΃qbg
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarB < 0 ) )
			pChip->bHit = true;

		// `bv`
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
			this->sfMap.Draw( 270, 38+pChip->nDotFromBarB, &s_rcChips[20] );
		break;
	}
	// BGM
	case 0x61: case 0x62: case 0x63: case 0x64: case 0x65: case 0x66: case 0x67: case 0x68: case 0x69: case 0x70:
	case 0x71: case 0x72: case 0x73: case 0x74: case 0x75: case 0x76: case 0x77: case 0x78: case 0x79: case 0x80:
	case 0x81: case 0x82: case 0x83: case 0x84: case 0x85: case 0x86: case 0x87: case 0x88: case 0x89: case 0x90:
	case 0x91: case 0x92: {

		// `bv`i0x61`0x65܂łj
		if( ! bSkip && ! pChip->bHit && pChip->bVisible && pChip->nChannel >= 0x61 && pChip->nChannel <= 0x65 )
			this->sfMap.Draw( 290+(pChip->nChannel-0x61)*12, BAR_Y-pChip->nDotFromBarD-1, &s_rcChips[21+pChip->nChannel-0x61] );

		// ĂȂΔ
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			if( ! bSkip ) {
				g_DTX.StopWave( this->structt.nŌɍĐBGM̎WAVԍ[ pChip->nChannel-0x61 ], 10 );
				g_DTX.PlayChip( pChip, 10, DTX_AUTOVOLUME );
				this->structt.nŌɍĐBGM̎WAVԍ[ pChip->nChannel-0x61 ] = pChip->nRealParam;
			}
			pChip->bHit = true;
		}
		break;
	}
	// ߐ
	case 0x50: {
			
		// part = ߔԍ(\ԍ+1)
		int part = (int)( pChip->dwPosition / 384 );

		// qbgĂȂ΂
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			pChip->bHit = true;

			// \pߔԍ̍XV
			this->structt.n݂̏ߔԍEfobO\p = part - 1;

			// WaveĐʒu␳
			if( ! bSkip )
				g_DTX.AdjustWaves();
		}
		// ߐ\
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
		{
			// BPM/BPx [ߐ\
			RECT rc;
			SetRect( &rc, s_rcLine.left, s_rcLine.top, s_rcLine.left + 23, s_rcLine.top + 1 );
			this->sfMap.Draw( 2, BAR_Y-pChip->nDotFromBarD, &rc );

			// h[ߐ\
			SetRect( &rc, s_rcLine.left, s_rcLine.top, s_rcLine.left + 103, s_rcLine.top + 1 );
			this->sfMap.Draw( 33, BAR_Y-pChip->nDotFromBarD, &rc );

			// BGM/BGA/AVI [ߐ\
			SetRect( &rc, s_rcLine.left, s_rcLine.top, s_rcLine.left + 34, s_rcLine.top + 1 );
			this->sfMap.Draw( 146, BAR_Y-pChip->nDotFromBarD, &rc );

			// M^[[ߐ\
			SetRect( &rc, s_rcLine.left, s_rcLine.top, s_rcLine.left + 45, s_rcLine.top + 1 );
			this->sfMap.Draw( 187, 38+pChip->nDotFromBarG, &rc );

			// x[X[ߐ\
			SetRect( &rc, s_rcLine.left, s_rcLine.top, s_rcLine.left + 45, s_rcLine.top + 1 );
			this->sfMap.Draw( 233, 38+pChip->nDotFromBarB, &rc );

			// SE1-5 [ߐ\
			SetRect( &rc, s_rcLine.left, s_rcLine.top, s_rcLine.left + 61, s_rcLine.top + 1 );
			this->sfMap.Draw( 289, BAR_Y-pChip->nDotFromBarD, &rc );
		}
		// ߔԍ\
		if( ! bSkip && ! pChip->bHit ) 
		{
			this->txNumbers.SetScale( 0.5f, 0.5f );
			this->t`( 125, BAR_Y-pChip->nDotFromBarD, part-1 );	// ߐ̉
			
			this->txNumbers.SetScale( 1.0f, 1.0f );
			this->t`( 640, 480, this->structt.n݂̏ߔԍEfobO\p );	// ʉÊł
		}
		break;
	}
	// 
	case 0x51: {
		
		// qbgĂȂ΂
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
			pChip->bHit = true;

		// [\
		if( ! bSkip && ! pChip->bHit && pChip->bVisible )
		{
			// BPM/BPx [\
			RECT rc;
			SetRect( &rc, s_rcSubLine.left, s_rcSubLine.top, s_rcSubLine.left + 23, s_rcSubLine.top + 1 );
			this->sfMap.Draw( 2, BAR_Y-pChip->nDotFromBarD, &rc );

			// h[\
			SetRect( &rc, s_rcSubLine.left, s_rcSubLine.top, s_rcSubLine.left + 103, s_rcSubLine.top + 1 );
			this->sfMap.Draw( 33, BAR_Y-pChip->nDotFromBarD, &rc );

			// BGM/BGA/AVI [\
			SetRect( &rc, s_rcSubLine.left, s_rcSubLine.top, s_rcSubLine.left + 34, s_rcSubLine.top + 1 );
			this->sfMap.Draw( 146, BAR_Y-pChip->nDotFromBarD, &rc );

			// SE1-5 [\
			SetRect( &rc, s_rcSubLine.left, s_rcSubLine.top, s_rcSubLine.left + 61, s_rcSubLine.top + 1 );
			this->sfMap.Draw( 289, BAR_Y-pChip->nDotFromBarD, &rc );
		}
		break;
	}
	// MIDI hR[X
	case 0x52: {
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
			pChip->bHit = true;		// Ȃ
		break;
	}
	// tBC
	case 0x53: {
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
			pChip->bHit = true;		// Ȃ
		break;
	}
	// AVI
	case 0x54: {
		
		if( ! pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
		{
			pChip->bHit = true;

			switch( pChip->AVItype )
			{
			case AVITYPE_AVI:
				if( pChip->pAVI )
				{
					// len = 0 Ȃ]̂ݗL
					this->actAVI.Start( pChip->nChannel, pChip->pAVI,
						BGA_W, BGA_H, 0, 0,			// sw, sh, ew, eh		; ̈   TCYAITCY
						0, 0, 0, 0,					// ssx, ssy, sex, sey	; 摜 ʒuAŏIʒu
						0, 0, 0, 0,					// dsx, dsy, dex, dey	; \ ʒuAŏIʒu
						0, pChip->dbTime );			// len, start
				}
				break;

			case AVITYPE_AVIPAN:
				if( pChip->pAVIPan )
				{
					this->actAVI.Start( pChip->nChannel, pChip->pAVI,
						pChip->pAVIPan->sw, pChip->pAVIPan->sh, pChip->pAVIPan->ew, pChip->pAVIPan->eh,		// ̈   TCYAITCY
						pChip->pAVIPan->ssx, pChip->pAVIPan->ssy, pChip->pAVIPan->sex, pChip->pAVIPan->sey,	// 摜 ʒuAŏIʒu
						pChip->pAVIPan->dsx, pChip->pAVIPan->dsy, pChip->pAVIPan->dex, pChip->pAVIPan->dey,	// \ ʒuAŏIʒu
						pChip->dbLong, pChip->dbTime );													// len, start
				}
				break;
			}
		}
		break;
	}
	// m
	default: {
		if( pChip->bHit && ( bSkip || pChip->nDotFromBarD < 0 ) )
			pChip->bHit = true;
		break;
	}
	}
}
void CStagePlay::tTEhĐ( DTX::Chip* pChip, EPlayPart part, long l )
{
	if( ! pChip )
		return;

	switch( part )
	{

	// hF
	// HHC, HHO ɂẮAOɔ~ĂĐBLC ̏ꍇ͖֌WB
	// AỎƍ̉Ƃ HHO ̏ꍇ͒~ȂB(HHO[΍j
	case PLAYPART_DRUMS:
		if( pChip->nChannel >= 0x11 && pChip->nChannel <= 0x1A )
		{
			int nLane = s_n`l0Ato[07[ pChip->nChannel - 0x11 ];

			if( nLane == 1 && ( pChip->nChannel == 0x11 || ( pChip->nChannel == 0x18 && this->structt.nŌɍĐHH̃`lԍ != 0x18 ) ) )
			{
				g_DTX.StopWave( this->structt.nŌɍĐHHWAVԍ, nLane );
				this->structt.nŌɍĐHHWAVԍ			= pChip->nRealParam;
				this->structt.nŌɍĐHH̃`lԍ	= pChip->nChannel;
			}
			g_DTX.PlayChip( pChip, nLane, l );
		}
		break;

	// M^[F
	// Ỏ~Ă甭
	case PLAYPART_GUITAR:
		g_DTX.StopWave( this->structt.nŌɍĐM^[WAVԍ, 8 );
		g_DTX.PlayChip( pChip, 8, l );
		this->structt.nŌɍĐM^[WAVԍ = pChip->nRealParam;
		break;

	// x[XF
	// Ỏ~Ă甭
	case PLAYPART_BASS:
		g_DTX.StopWave( this->structt.nŌɍĐx[XWAVԍ, 9 );
		g_DTX.PlayChip( pChip, 9, l );
		this->structt.nŌɍĐx[XWAVԍ = pChip->nRealParam;
		break;
	}
}
void CStagePlay::t`( int rx, int by, int num )
{
	// ͕\Ȃ
	if( num < 0 ) return;

	// lƂɕiU܂ŁGȏ͖j
	int pn[ 6 ];
	for( int i = 0; i < 6; i++ )
	{
		int n = num % 10;
		num = (num - n) / 10;
		pn[ 5-i ] = n;
	}

	// 摜̍vTCY̎Zo
	int w = 0;
	int h = 0;
	float fw, fh;
	bool bf = true;		// ŏ̂O͖

	this->txNumbers.GetScale( &fw, &fh );
	
	for( int i = 0; i < 6; i++ )
	{
		if( pn[i] == 0 && bf && i < 5 ) continue;
		w += (int)( (s_rcNums[ pn[i] ].right - s_rcNums[ pn[i] ].left) * fw );
		h = (int)( MAX( h, (s_rcNums[ pn[i] ].bottom - s_rcNums[ pn[i] ].top) ) * (fh+0.2f) );
		bf = false;
	}

	// `
	int x = rx - w;
	int y = by - h;
	bf = true;
	for( int i = 0; i < 6; i++ )
	{
		if( pn[i] == 0 && bf && i < 5 ) continue;
		this->txNumbers.Draw( x, y, &s_rcNums[ pn[i] ] );
		x += (int)( (s_rcNums[ pn[i] ].right - s_rcNums[ pn[i] ].left) * fw );
		bf = false;
	}
}
void CStagePlay::tt()
{
	this->structt.bt = false;
	this->structt.p݂̃gbvChip = NULL;
	this->structt.n݂̏ߔԍEfobO\p = 0;
	this->structt.db݂BPMEfobO\p = 0.0;
	this->structt.dbJnms = INIT_TIME;
	for( int i = 0; i < 50; i++ )
		this->structt.nŌɍĐBGM̎WAVԍ[i] = -1;
	this->structt.nŌɍĐHHWAVԍ			= -1;
	this->structt.nŌɍĐHH̃`lԍ	= 0;
	this->structt.nŌɍĐM^[WAVԍ		= -1;
	this->structt.nŌɍĐx[XWAVԍ		= -1;
}
//
bool CStagePlay::MyOneTimeSceneInit()
{
	// ɃR[hLqBAddChild() ȂǁB
	AddChild( &this->sfMap );
	AddChild( &this->txNumbers );
	AddChild( &g_DTX );
	AddChild( &this->actAVI );

	g_DTX.bDTXV = true;
	g_DTX.SetTimer( &g_Timer );

	return CStage::MyOneTimeSceneInit();
}
bool CStagePlay::MyFinalCleanup()
{
	// ɃR[hLqB

	return CStage::MyFinalCleanup();
}
bool CStagePlay::MyInitDeviceObjects()
{
	// ɃR[hLqBCTexture/CSurface::InitDeviceObjects() ȂǁB
	this->sfMap.InitDeviceObjectsFromResource( _T("}bv"), MAKEINTRESOURCE(IDR_PNG_MAP), _T("PNG") );
	this->sfMap.ColorKeyEnable();
	this->txNumbers.InitDeviceObjectsFromResource( _T(""), MAKEINTRESOURCE(IDR_PNG_NUMBERS), _T("PNG") );

	return CStage::MyInitDeviceObjects();
}
bool CStagePlay::MyDeleteDeviceObjects()
{
	// ɃR[hLqB

	//  CStage::MyDeleteDeviceObjects() ł́AqeNX`EqT[tFCX Delete (CTexture/CSurface::Delete) sB
	return CStage::MyDeleteDeviceObjects();
}
bool CStagePlay::MyActivate()
{
	this->bFirstWork = true;
	// ɃR[hLqB
	this->tt();

	this->phaseID = PHASE_PLAY_IDLE;
	this->bLoadingv = false;
	this->bPlayingv = false;
	this->nJnߔԍ = 0;

	//  CStage::MyActivate() ł́Athis->bActivity ̃ZbgȂтɎqT[tFCXEqeNX` Restore (MyRestoreDeviceTexture/Surface) sB
	// ȂAq Activity ͍̊sȂBĩ\bh𔲂ĂsBj
	return CStage::MyActivate();
}
bool CStagePlay::MyUnActivate()
{
	// ɃR[hLqB

	//  CStage::MyUnActivate() ł́Athis->bActivity ̃ZbgȂтɎqT[tFCXEqeNX` Invalidate (MyInvalidateDeviceObjects) sB
	// ȂAqActivity ̔񊈐͍sȂBĩ\bh𔲂ĂsBj
	return CStage::MyUnActivate();
}
bool CStagePlay::MyRestoreDeviceTextures()
{
	// ɃR[hLqB

	//  CStage::MyRestoreDeviceTextures() ł́AqeNX` Restore (CTexture::Restore) sB
	return CStage::MyRestoreDeviceTextures();
}
bool CStagePlay::MyRestoreDeviceSurfaces()
{
	// ɃR[hLqB

	//  CStage::MyRestoreDeviceSurfaces() ł́AqT[tFCX Restore (CSurface::Restore) sB
	return CStage::MyRestoreDeviceSurfaces();
}
bool CStagePlay::MyInvalidateDeviceObjects()
{
	// ɃR[hLqB

	//  CStage::MyInvalidateDeviceObjects() ł́AqeNX`EqT[tFCX Invalidate (CTexture/CSurface::Invalidate) sB
	return CStage::MyRestoreDeviceSurfaces();
}
		}//Play
	}//Stage
}//DTXViewer
