#include "stdafx.h"
#include "CCounter.h"
#include "CTimer.h"

namespace FDK {
	namespace General {

CCounter::CCounter()
{
	this->pTimer = NULL;
	this->nValue = 0;
	this->dbTimer = INIT_TIME;
	this->nJnl = 0;
	this->nIl = 0;
	this->dbԊu  = 0.0;
}
void CCounter::Start( int nJnl, int nIl, int nԊums, CTimer* pTimer )
{
	this->nJnl = nJnl;
	this->nIl = nIl;
	this->dbԊu  = (double) nԊums;
	this->pTimer  = pTimer;

	_ASSERT( this->pTimer );

	this->dbTimer = this->pTimer->Get();
	this->nValue  = nJnl;
}
void CCounter::Step()
{
	if( this->dbTimer == INIT_TIME )
		return;

	_ASSERT( this->pTimer );

	double dbNow = this->pTimer->Get();
	
	if( dbNow < this->dbTimer )
		this->dbTimer = dbNow;

	while( dbNow - this->dbTimer >= this->dbԊu )
	{
		if( ++this->nValue > this->nIl )
			this->nValue = this->nIl;
		this->dbTimer += dbԊu;
	}
}
void CCounter::StepLoop()
{
	_ASSERT( this->pTimer );
	
	if( this->dbTimer == INIT_TIME )
		return;

	double dbNow = this->pTimer->Get();
	
	if( dbNow < this->dbTimer )
		this->dbTimer = dbNow;

	while( dbNow - this->dbTimer >= this->dbԊu )
	{
		if( ++this->nValue > this->nIl )
			this->nValue = this->nJnl;
		this->dbTimer += dbԊu;
	}
}
void CCounter::Stop()
{
	this->dbTimer = INIT_TIME;
}
bool CCounter::bIlɒB()
{
	return ( this->nValue == this->nIl ) ? true : false;
}
bool CCounter::b쒆()
{
	return ( this->dbTimer != INIT_TIME )? true : false;
}
	}//General
}//FDK
