#include "stdafx.h"
#include "Debug.h"
#include "CD3DDisplay.h"
#include "CTimer.h"
#include "WindowPositions.h"
#include "FDKError.h"
#include "CTexture.h"
#include "CD3DApplication.h"

namespace FDK {
	namespace AppBase {

// static Ȃ
LPDIRECTDRAW7			CD3DApplication::pDD = NULL;
LPDIRECTDRAWSURFACE7	CD3DApplication::pddsFrontBuffer = NULL;
LPDIRECTDRAWSURFACE7	CD3DApplication::pddsBackBuffer = NULL;
LPDIRECT3D7				CD3DApplication::pD3D = NULL;
LPDIRECT3DDEVICE7		CD3DApplication::pD3DDevice = NULL;
CD3DDisplay				CD3DApplication::D3DDisplay;
HWND					CD3DApplication::hWnd = NULL;
int						CD3DApplication::nBpp = 16;

// Ǐϐ
static CD3DApplication* s_pD3DApp = NULL;		// WndProcp

// static WndProc
LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	return ( s_pD3DApp ) ? s_pD3DApp->WndProc( hWnd, uMsg, wParam, lParam ) : DefWindowProc( hWnd, uMsg, wParam, lParam );
}
//
CD3DApplication::CD3DApplication()
{
	// Oϐ̏
	s_pD3DApp					= this;

	// ϐ̏
	this->nWidth				= 640;
	this->nHeight				= 480;
	this->nBpp					= 16;
	this->bSʃ[h			= false;
	this->hWnd					= NULL;
	this->bA			= true;
	this->dw`Ԋu			= 3;
	this->bReady				= false;
	this->bActive				= false;
    this->strWindowTitle		= _T("FDK10 Application");
    this->strWindowClass		= _T("FDK10 WindowClass");
	this->dwEBhEX^C	= WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_VISIBLE;
	this->dwSʃX^C		= WS_POPUP | WS_VISIBLE;
	this->bScreenSaverEnable	= false;
}
HRESULT CD3DApplication::Create( HINSTANCE hInst, LPCTSTR strCmdLine )
{
	HRESULT hr;

	this->hInstance   = hInst;

	// IME 𖳌
	{
		WINNLSEnableIME( NULL, FALSE );
	}
	//
	// EBhE쐬܂Ȃ炱ō쐬
	{
		if( this->hWnd == NULL )
		{
			WNDCLASS wndClass = {
				0,										// NXX^C
				FDK::AppBase::WndProc,					// bZ[WvV[W
				0,										// ClsExtra
				0,										// WndExtra
				this->hInstance,						// CX^X
				NULL,									// EBhEACR
				LoadCursor( NULL, IDC_ARROW ),			// }EXACR
				(HBRUSH)GetStockObject( WHITE_BRUSH ),	// wiuV
				NULL,									// j[
				this->strWindowClass					// NX
			};
			::RegisterClass( &wndClass );

			RECT rc = { 0, 0, this->nWidth, this->nHeight };
			::AdjustWindowRect( &rc, this->dwEBhEX^C, FALSE );
			this->hWnd = ::CreateWindow(
				this->strWindowClass,
				this->strWindowTitle,
				(this->bSʃ[h) ? this->dwSʃX^C : this->dwEBhEX^C,
				CW_USEDEFAULT, CW_USEDEFAULT,
				(rc.right-rc.left), (rc.bottom-rc.top), 0L,
				NULL, this->hInstance, 0L );
		}
	}
	//
	// EBhËiXN[Wj̎擾Eۑ
	{
		this->t݂̃EBhẼEBhËƃNCAg̈擾();
	}
	//
	// A_v^^foCX^[h̗
	{
		if( FAILED( hr = this->D3DDisplay.EnumerateDevices() ) )
			return hr;	// s
	}
	//
	// Rc̍\z
	{
		if( FAILED( hr = t3D̍\z() ) )
			return hr;
	}
	//
	// Av̈x̏
	{
		if( FAILED( hr = OneTimeSceneInit() ) ) {
			t3D̔j();
			return hr;
		}
	}
	//
	// foCXˑIuWFNg̏
	{
		if( FAILED( hr = InitDeviceObjects() ) ) {
			t3D̔j();
			return hr;
		}
	}
	//
	// foCXˑIuWFNg̍\z
	{
		if( FAILED( hr = RestoreDeviceObjects() ) ) {
			t3D̔j();
			return hr;
		}
	}	
	//
	// 
	this->bReady = true;

	return S_OK;
}
HRESULT CD3DApplication::t3D̍\z()
{
	HRESULT hr;
	
	D3DAdapterInfo* pAdapter = this->D3DDisplay.pAdapter;
	D3DDeviceInfo*  pDevice  = pAdapter->pDevice;

	// j^̓dݒꎞIɖɂ
	{
		this->exeState = ::SetThreadExecutionState( ES_DISPLAY_REQUIRED | ES_CONTINUOUS );
	}
	//
	// XN[Z[o̗LE擾ǍꎞIɖɂ
	{
		HKEY	hKeyScreenSaver = NULL;
		long	lReturn = 0;
		long	lScreenSaver = 0;
		DWORD	dwData = 0;

		if( RegOpenKeyEx( HKEY_CURRENT_USER, TEXT("Control Panel\\Desktop"), 0, KEY_QUERY_VALUE, &hKeyScreenSaver ) == ERROR_SUCCESS )
		{
			this->bScreenSaverEnable = 
				( RegQueryValueEx( hKeyScreenSaver, TEXT("SCRNSAVE.EXE"), NULL, NULL, NULL, &dwData ) == ERROR_SUCCESS ) ? true : false;
		}
		RegCloseKey( hKeyScreenSaver );
		hKeyScreenSaver = NULL;

		// ɂ
		SystemParametersInfo( SPI_SETSCREENSAVEACTIVE, FALSE, 0, SPIF_SENDWININICHANGE );
	}
	//
	// SEBhEʒu̕ۑ
	{
		WindowPositions::Save();
	}
	//
	// ^C}̏; ^C}ʂύXꍇ́Ax Term()  Init() ȂƁB
	{
		this->timer.Init( TIMERTYPE_TIMEGTTIME );
	}
	//
	// D3DX ̏
	{
		if( FAILED( hr = D3DXInitialize() ) )
			return hr;
	}
	//
	// DirectDraw7 ̍쐬
	{
		if( FAILED( hr = DirectDrawCreateEx( NULL, (VOID**)&this->pDD, IID_IDirectDraw7, NULL ) ) ) {
			D3DXUninitialize();
			return hr;
		}
	}
	//
	// [h̐ݒ
	{
		if( FAILED( hr = this->pDD->SetCooperativeLevel( this->hWnd, this->bSʃ[h ? (DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN) : (DDSCL_NORMAL|DDSCL_NOWINDOWCHANGES) ) ) ) 
		{
			SAFE_RELEASE( this->pDD );
			D3DXUninitialize();
			return hr;
		}
	}
	//
	// fBXvC[h̐ݒiSʃ[ĥ݁j
	{
		if( this->bSʃ[h )
		{
			if( FAILED( hr = this->pDD->SetDisplayMode( this->nWidth, this->nHeight, this->nBpp, 0, 0 ) ) )
			{
				SAFE_RELEASE( this->pDD );
				D3DXUninitialize();
				return hr;
			}
		}
	}
	//
	// vC}obNT[tFCX̍쐬
	{
		// a. Sʃ[h̏ꍇ
		if( this->bSʃ[h )
		{
			DDSURFACEDESC2 ddsd;
			ZeroMemory( &ddsd, sizeof( ddsd ) );
			ddsd.dwSize	= sizeof( ddsd );
			ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
			ddsd.ddsCaps.dwCaps	= DDSCAPS_PRIMARYSURFACE | DDSCAPS_3DDEVICE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
			ddsd.dwBackBufferCount = 1;
			if( FAILED( hr = this->pDD->CreateSurface( &ddsd, &this->pddsFrontBuffer, NULL ) ) ) {
				D3DXUninitialize();
				SAFE_RELEASE( this->pDD );
				return hr;	// vC}T[tFCX̍쐬Ɏs
			}
			DDSCAPS2 ddscaps;
			ZeroMemory( &ddscaps, sizeof( ddscaps ) );
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
			if( FAILED( hr = this->pddsFrontBuffer->GetAttachedSurface( &ddscaps, &this->pddsBackBuffer ) ) )
			{
				D3DXUninitialize();
				SAFE_RELEASE( this->pddsFrontBuffer );
				SAFE_RELEASE( this->pDD );
				return hr;	// obNT[tFCX̎擾Ɏs
			}
		}
		//
		// b. EBhE[h̏ꍇ
		else
		{
			DDSURFACEDESC2 ddsd;
			ZeroMemory( &ddsd, sizeof( ddsd ) );
			ddsd.dwSize = sizeof( ddsd );
			ddsd.dwFlags = DDSD_CAPS;
			ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_3DDEVICE;
			if( FAILED( hr = this->pDD->CreateSurface( &ddsd, &this->pddsFrontBuffer, NULL ) ) ) {
				SAFE_RELEASE( this->pDD );
				D3DXUninitialize();
				return hr;	// vC}T[tFCX̍쐬Ɏs
			}
			ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
			ddsd.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_OFFSCREENPLAIN;
			ddsd.dwWidth = this->nWidth;
			ddsd.dwHeight = this->nHeight;
			if( FAILED( hr = this->pDD->CreateSurface( &ddsd, &this->pddsBackBuffer, NULL ) ) ) {
				SAFE_RELEASE( this->pddsFrontBuffer );
				SAFE_RELEASE( this->pDD );
				D3DXUninitialize();
				return hr;	// obNT[tFCX̍쐬Ɏs
			}
		}
	}
	//
	// Nbp[̍쐬iEBhE[ĥ݁j
	{
		if( ! this->bSʃ[h )
		{
			LPDIRECTDRAWCLIPPER pClipper;
			if( FAILED( hr = this->pDD->CreateClipper( 0, &pClipper, NULL ) ) )
			{
				SAFE_RELEASE( this->pddsBackBuffer );
				SAFE_RELEASE( this->pddsFrontBuffer );
				SAFE_RELEASE( this->pDD );
				D3DXUninitialize();
				return hr;	// Nbp[̍쐬Ɏs
			}
			pClipper->SetHWnd( 0, this->hWnd );
			this->pddsFrontBuffer->SetClipper( pClipper );
			SAFE_RELEASE( pClipper );
		}
	}
	//
	// Direct3D ̎擾
	{
		if( FAILED( hr = this->pDD->QueryInterface( IID_IDirect3D7, (LPVOID *) &this->pD3D ) ) )
		{
			if( ! this->bSʃ[h ) SAFE_RELEASE( this->pddsBackBuffer );
			SAFE_RELEASE( this->pddsFrontBuffer );
			SAFE_RELEASE( this->pDD );
			D3DXUninitialize();
			return hr;	// Direct3D7 ̎擾Ɏs
		}
	}
	//
	// Direct3D foCX̍쐬
	{
		if( FAILED( hr = this->pD3D->CreateDevice( IID_IDirect3DTnLHalDevice, this->pddsBackBuffer, &this->pD3DDevice ) ) )				// TnLHAL ŃgC
		{
			if( FAILED( hr = this->pD3D->CreateDevice( IID_IDirect3DHALDevice, this->pddsBackBuffer, &this->pD3DDevice ) ) )			// HAL ŃgC
			{
				if( FAILED( hr = this->pD3D->CreateDevice( IID_IDirect3DMMXDevice, this->pddsBackBuffer, &this->pD3DDevice ) ) )		// MMX ŃgC
				{
					if( FAILED( hr = this->pD3D->CreateDevice( IID_IDirect3DRGBDevice, this->pddsBackBuffer, &this->pD3DDevice ) ) )	// RGB ŃgC
					{
						SAFE_RELEASE( this->pD3D );
						if( ! this->bSʃ[h ) SAFE_RELEASE( this->pddsBackBuffer );
						SAFE_RELEASE( this->pddsFrontBuffer );
						SAFE_RELEASE( this->pDD );
						D3DXUninitialize();
						return hr;	// Direct3DDevice ̍쐬Ɏs
					} else
						Debug::Msg( _T("Direct3D RGB foCX쐬܂B\n") );
				} else
					Debug::Msg( _T("Direct3D MMX foCX쐬܂B\n") );
			} else
				Debug::Msg( _T("Direct3D HAL foCX쐬܂B\n") );
		} else
			Debug::Msg( _T("Direct3D T&L HAL foCX쐬܂B\n") );
	}
	//
	// foCXɃr[|[gݒ
	{
		D3DVIEWPORT7 vp = { 0, 0, this->nWidth, this->nHeight, 0.0f, 1.0f };
		if( FAILED( hr = this->pD3DDevice->SetViewport( &vp ) ) )
		{
			SAFE_RELEASE( this->pD3DDevice );
			SAFE_RELEASE( this->pD3D );
			if( ! this->bSʃ[h ) SAFE_RELEASE( this->pddsBackBuffer );
			SAFE_RELEASE( this->pddsFrontBuffer );
			SAFE_RELEASE( this->pDD );
			D3DXUninitialize();
			return hr;	// r[|[g̐ݒɎs
		}
	}
	//
	// sς̃_OXe[^X̐ݒ
	{
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, FALSE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_ANTIALIAS, FALSE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, TRUE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_ALPHAREF, 10 );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATER );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP,		D3DTOP_SELECTARG1 );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1,	D3DTA_TEXTURE );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,		D3DTOP_MODULATE );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1,	D3DTA_TEXTURE );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2,	D3DTA_DIFFUSE );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER,	D3DTFN_POINT );
		this->pD3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER,	D3DTFN_POINT );
	}
	//
	// KXύX郌_OXe[^X̐ݒ
	{
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_COLORKEYENABLE, FALSE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA );
		this->pD3DDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA );
	}
	//
	// ˉesftHĝ̂ύX
	{
		float d, t, a;
		D3DXMATRIX proj;
		CD3DApplication::GetProjectionParam( &d, &t, &a );
		D3DXMatrixPerspectiveFovLH( &proj, t, 1.0f, 0.0000001f, 50.0f );
		D3DMATRIX pm = proj;
		this->pD3DDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &pm );
	}
	//
	// }EXJ[\\ON/OFF
	{
		if( this->bSʃ[h ) {
			while( ShowCursor( FALSE ) >= 0 )
				Sleep(2);
		} else {
			ShowCursor( TRUE );
		}
	}

	return S_OK;
}
void	CD3DApplication::t3D̔j()
{
	this->bActive = false;
	this->bReady  = false;

	// Av̏I
	{
		InvalidateDeviceObjects();
		DeleteDeviceObjects();
		FinalCleanup();
	}
	//
	// fBXvC[h̕
	{
		if( this->bSʃ[h )
			this->pDD->RestoreDisplayMode();
	}
	//
	// e DirectX IuWFNg̉
	{
		this->pDD->SetCooperativeLevel( this->hWnd, DDSCL_NORMAL | DDSCL_NOWINDOWCHANGES );
		SAFE_RELEASE( this->pD3DDevice );
		SAFE_RELEASE( this->pD3D );
		if( ! this->bSʃ[h ) SAFE_RELEASE( this->pddsBackBuffer );
		SAFE_RELEASE( this->pddsFrontBuffer );
		SAFE_RELEASE( this->pDD );
		D3DXUninitialize();
	}
	//
	// SEBhËʒu𕜌iSʃ[ĥ݁j
	{
		if( this->bSʃ[h )
			WindowPositions::Load();
		WindowPositions::Clear();		// Xg
	}
	//
	// ^C}I
	{
		this->timer.Term();
	}
	//
	// XN[Z[oLȂƂɖ߂
	{
		if( this->bScreenSaverEnable )
			SystemParametersInfo( SPI_SETSCREENSAVEACTIVE, TRUE, 0, SPIF_SENDWININICHANGE );
	}
	//
	// j^dݒ̕
	{
		::SetThreadExecutionState( this->exeState );
	}
}
HRESULT CD3DApplication::t3D̍č\z( bool bVSʃ[h )
{
	HRESULT hr;

	this->bReady = false;
	
	// ׂẴfoCXˑIuWFNg
	{
		InvalidateDeviceObjects();
	}
	//
	// ݑSʃ[hȂfBXvC[h𕜌
	{
		if( this->bSʃ[h )
			this->pDD->RestoreDisplayMode();
	}
	//
	// e DirectX IuWFNg̉
	{
		this->pDD->SetCooperativeLevel( this->hWnd, DDSCL_NORMAL | DDSCL_NOWINDOWCHANGES );
		SAFE_RELEASE( this->pD3DDevice );
		SAFE_RELEASE( this->pD3D );
		if( ! this->bSʃ[h ) SAFE_RELEASE( this->pddsBackBuffer );
		SAFE_RELEASE( this->pddsFrontBuffer );
		SAFE_RELEASE( this->pDD );
		D3DXUninitialize();
	}
	//
	// EBhEX^C̐ݒ
	{
		// EBhEX^CύXꍇ́ASetWindowsPos() œLbVNAKvB
		if( bVSʃ[h )
		{
			::SetWindowLongPtr( this->hWnd, GWL_STYLE, this->dwSʃX^C );
			::SetWindowPos( this->hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED );
		}
		else
		{
			::SetWindowLongPtr( this->hWnd, GWL_STYLE, this->dwEBhEX^C );
			::SetWindowPos( this->hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_FRAMECHANGED | SWP_SHOWWINDOW );
		}
	}
	//
	// SEBhEʒuƃTCY̕iSʃ[ĥ݁j
	{
		if( this->bSʃ[h )
		{
			// EBhEʒu
			WindowPositions::Load();
			WindowPositions::Clear();

			this->t݂̃EBhẼEBhËƃNCAg̈擾();
		}
	}
	//
	// foCX̍\z
	{
		bool bۑ = this->bSʃ[h;
		this->bSʃ[h = bVSʃ[h;		// t3D̍\z() ̑O this->bSʃ[h ̐ݒ肪Kv
	
		if( FAILED( hr = this->t3D̍\z() ) ) {
			this->bSʃ[h = bۑ;
			return hr;
		}
	}
	//
	// foCXˑIuWFNg̑̕OɁAWait a moment 摜oĂBiƂ̂߁j
	{
		CTexture::BeginScene();
		this->tWaitAMoment̕`();
		CTexture::EndScene();
		this->tFlip܂Blt();
	}
	//
	// foCXˑIuWFNg̕
	{
		if( FAILED( hr = this->RestoreDeviceObjects() ) )
			return hr;
	}
	//
	// 
	this->bReady = true;

	return S_OK;
}
HRESULT CD3DApplication::t3D̕`()
{
	HRESULT hr;

	// x`FbN
	{
		if( FAILED( hr = this->pDD->TestCooperativeLevel() ) )
		{
			switch( hr )
			{
			case DDERR_EXCLUSIVEMODEALREADYSET:		// iEBhE[ĥƂj̃Avr[hɓ
			case DDERR_NOEXCLUSIVEMODE:				// riAlt+TABȂǁj
				Sleep( 1000 );		// ̃Avr[hɓĂ̂őҋ@BʂCPUgȂ(2006/5/6)
				return S_OK;

			case DDERR_WRONGMODE:					// fBXvC[hύXꂽBST[tFCXjč蒼KvB
				if( this->D3DDisplay.pAdapter->pDevice->bWindowed )
				{
					hr = this->t3D̍č\z( this->bSʃ[h );
					return hr;
				}
				break;
			}
			return hr;
		}
	}
	//
	// is`
	{
		if( this->Render() )
		{
			// Render()  true Ԃ WM_CLOSE 𑗐MB
			SendMessage( this->hWnd, WM_CLOSE, 0, 0 );
			return S_OK;
		}

		this->tFPSZo();
	}
	//
	// \
	{
		if( FAILED( hr = this->tFlip܂Blt() ) )
		{
			if( hr == DDERR_SURFACELOST )
			{
				// T[tFCXׂĕAč\zB
				this->pDD->RestoreAllSurfaces();
				return this->RestoreDeviceObjects();
			}
			else
				return hr;	// ̑̃G[
		}
	}
	//
	return S_OK;
}
HRESULT CD3DApplication::tFlip܂Blt()
{
	HRESULT hr = S_OK;

    if( this->pddsFrontBuffer == NULL )
		return FDKERR_ĂȂ;

    // Sʃ[hF
	if( this->bSʃ[h )
    {
		if( this->bA )
		{
			hr = this->pddsFrontBuffer->Flip( NULL, DDFLIP_WAIT );
			return hr;
		}
		else
		{
			return this->tgȂEFCgBlt( NULL );
		}
    }

    // EBhE[hF
    else
	{
		return this->tgȂEFCgBlt( &this->rcNCAg̈ );
	}

	return hr;
}
HRESULT	CD3DApplication::tgȂEFCgBlt( LPRECT prcNCAg̈ )
{
	static bool   bBltFastg = true;		// ̂ BltFast ŎA_Ȃ炻ȍ~BltgB
	static double dbO̕`Jn = INIT_TIME;

	HRESULT hr = S_OK;

	if( dbO̕`Jn != INIT_TIME )
	{
		double dboߎ = this->timer.GetSysTime() - dbO̕`Jn;
		double db]莞 = (double)this->dw`Ԋu - dboߎ;
		if( db]莞 > 0 )
			::Sleep( (DWORD)db]莞 );		// ]莞Ԃ
	}

retry:
	if( bBltFastg )
	{
		RECT rcBack = { 0, 0, this->nWidth, this->nHeight };
		if( FAILED( hr = this->pddsFrontBuffer->BltFast( 0, 0, this->pddsBackBuffer, &rcBack, DDBLTFAST_WAIT ) ) )
		{
			bBltFastg = false;	// BltFast() ɎŝŁAȌ Blt() gB
			goto retry;
		}
	}
	else
		hr = this->pddsFrontBuffer->Blt( prcNCAg̈, this->pddsBackBuffer, NULL, DDBLT_WAIT, NULL );

	dbO̕`Jn = this->timer.GetSysTime();
	
	return hr;
}
//
void	CD3DApplication::tSʁEEBhE[h؂ւ()
{
	HRESULT hr;

	// ݃EBhE[hȂSEBhËʒuۑ
	if( ! this->bSʃ[h )
		WindowPositions::Save();

	// foCX؂ւ
	if( FAILED( hr = t3D̍č\z( ! this->bSʃ[h ) ) )
	{
		// s猳ɖ߂iP񂾂j
		if( FAILED( hr = t3D̍č\z( this->bSʃ[h ) ) )
			return;	// łG[o疳
	}
}

void	CD3DApplication::t݂̃EBhẼEBhËƃNCAg̈擾()
{
	// EBhË̎擾
	GetWindowRect( this->hWnd, &this->rcEBhË );

	// NCAg̈̎擾
	GetClientRect( this->hWnd, &this->rcNCAg̈ );
	ClientToScreen( this->hWnd, (POINT*)&this->rcNCAg̈.left );		// left, top	 XN[W
	ClientToScreen( this->hWnd, (POINT*)&this->rcNCAg̈.right );		// right, bottom XN[W
}

void	CD3DApplication::tWaitAMoment̕`()
{
/*
	ȉ̓Tv

	CSurface sf;
	sf.InitDeviceObjectsFromFile( _T("Wait a moment"), _T("sysdata/ses_frame.jpg") );
	if( SUCCEEDED( sf.RestoreDeviceObjects() ) )
	{
		sf.Draw( 0, 0 );
		sf.InvalidateDeviceObjects();
	}
	sf.DeleteDeviceObjects();
*/
}

void	CD3DApplication::tFPSZo()
{
	static double fpstime = INIT_TIME;
	static int fps = 0;

	// 
	if( fpstime == INIT_TIME )
	{
		fpstime = this->timer.GetSysTime();
		this->nFPS = fps = 0;
	}

	// Pbo߂ƂɌvZ
	while( this->timer.GetSysTime() - fpstime >= 1000.0 )
	{
		this->nFPS = fps;
		fps = 0;
		fpstime += 1000.0;
	}
	fps ++;
}
//
INT		CD3DApplication::Run()
{
    MSG  msg;

	while( true )
    {
		if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
		{
			if( msg.message == WM_QUIT )
				break;
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
		else
		{
			if( this->bReady && this->bActive )
			{
				if( FAILED( t3D̕`() ) ) {
					Debug::Msg( _T("3D̕`Ɏs܂BI܂B\n") );
					SendMessage( this->hWnd, WM_CLOSE, 0, 0 );
				}
			}
		}
	}
    return (INT)msg.wParam;
}
LRESULT CD3DApplication::WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
    switch( uMsg )
    {

	case WM_CLOSE:
		this->bActive = false;
		this->t3D̔j();
		break;

	case WM_DESTROY:
		PostQuitMessage( 0 );
		return 0;

	case WM_SIZE:
		// EBhESBꂽŏꂽ肵 this->bActive = false ɂB
		this->bActive = ( wParam == SIZE_MAXHIDE || wParam == SIZE_MINIMIZED ) ? false : true;
		break;

	case WM_MOVE:
		// V̈W擾Ă
		this->t݂̃EBhẼEBhËƃNCAg̈擾();
		break;

	case WM_GETMINMAXINFO:
		// Av̍ŏTCY̖₢킹ւ̉񓚁B
		((MINMAXINFO*)lParam)->ptMinTrackSize.x = 100;
		((MINMAXINFO*)lParam)->ptMinTrackSize.y = 100;
		return 0;

	case WM_NCHITTEST:
		if( this->bSʃ[h )
			return HTCLIENT;		// ׂĂNCAg̈
		break;
	}
	return DefWindowProc( hWnd, uMsg, wParam, lParam );
}
	}//AppBase
}//FDK