#include "stdafx.h"
#include "CSound.h"
#include "CSoundManager.h"
#include "FDKError.h"
#include "CFileMM.h"
#include "xadec.h"
#include "vorbis/vorbisfile.h"
#include "COgg.h"
#include "Debug.h"

namespace FDK {
	namespace Sound {

CSound::CSound()
{
	this->pDSBuffer = NULL;
}
void	CSound::Init()
{
	SAFE_RELEASE( this->pDSBuffer );
	this->dwDSBufferSize = 0;
	this->strFileName[0] = _T('\0');
	this->lVolume = DSBVOLUME_MAX;
	this->lPan = 0;
	this->fSpeed = 1.0f;
	this->fPitch = 1.0f;
	this->bLoop = false;
	this->nPause = 0;
	this->dwCurrentPosition = 0;
}
void	CSound::Term()
{
	Init();
}
HRESULT CSound::DuplicateFromSound( LPDIRECTSOUND8 pDS, CSound* srcSound )
{
	HRESULT hr;

	// `FbN
	if( ! pDS )
		return FDKERR_DirectSoundNULL;
	if( ! srcSound )
		return FDKERR_TEhobt@NULL;
	if( this->pDSBuffer )
		Term();		// pȂ̂ŐɏIs

	// TEh̕
	if( FAILED( hr = pDS->DuplicateSoundBuffer( srcSound->GetDirectSoundBuffer(), &this->pDSBuffer ) ) )
		return FDKERR_TEhobt@̍쐬Ɏs;
	
	// TEhobt@TCY̎擾
	this->dwDSBufferSize = srcSound->GetDirectSoundBufferSize();

	return S_OK;
}
HRESULT	CSound::CreateFromFile( LPDIRECTSOUND8 pDS, LPCTSTR filename )
{
	HRESULT hr;

	// `FbN
	if( ! pDS )
		return FDKERR_DirectSoundNULL;

	// t@C̓ǂݍ
	CFileMM file;
	if( ! file.Load( filename ) )
	{
		file.Term();
		return FDKERR_t@C̓ǂݍݎs;
	}

	// t@Cf[^̃TEhobt@쐬
	if( FAILED( hr = CreateFromMemory( pDS, file.GetData(), file.GetSize() ) ) )
	{
		file.Term();
		return FDKERR_TEhobt@̍쐬Ɏs;
	}

	lstrcpyn( this->strFileName, filename, _MAX_PATH );
	file.Term();

	return S_OK;
}
HRESULT	CSound::CreateFromMemory( LPDIRECTSOUND8 pDS, BYTE* pData, DWORD dwSize )
{
	HRESULT hr;

	// `FbN
	if( ! pData || dwSize == 0)
		return E_INVALIDARG;
	
	if( ! pDS )
		return FDKERR_DirectSoundNULL;
	
	if( this->pDSBuffer )
		Term();	// pȂ̂ŁAɏIs

	// TEh̃fR[h
	if( FAILED( hr = DecodeFromOgg( pDS, pData, dwSize ) ) )
	if( FAILED( hr = DecodeFromXA(  pDS, pData, dwSize ) ) )
	if( FAILED( hr = DecodeFromMP3( pDS, pData, dwSize ) ) ) 
	if( FAILED( hr = DecodeFromWAV( pDS, pData, dwSize ) ) )
		return FDKERR_TEhobt@̍쐬Ɏs;		// T|[gf[^

	return hr;
}

HRESULT CSound::CreateAndCopyBuffer( LPDIRECTSOUND8 pDS, WAVEFORMATEX* pwfx, BYTE* pData, DWORD dwSize )
{
	HRESULT hr;

	this->dwDSBufferSize = dwSize;

	// TEhobt@̐
    DSBUFFERDESC dsbd;
    ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
	dsbd.dwSize          = sizeof(DSBUFFERDESC);
	dsbd.dwFlags         = DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLPAN | DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_CTRLFREQUENCY | DSBCAPS_LOCDEFER;
	dsbd.dwBufferBytes   = dwSize;
	dsbd.guid3DAlgorithm = DS3DALG_DEFAULT;
	dsbd.lpwfxFormat     = pwfx;
	if( FAILED( hr = pDS->CreateSoundBuffer( &dsbd, &this->pDSBuffer, NULL ) ) )
		return FDKERR_TEhobt@̍쐬Ɏs;

	// TEhobt@ Lost `FbN
	if( FAILED( hr = RestoreBuffer( this->pDSBuffer, NULL ) ) )
		return hr;

	// fR[hf[^TEhobt@ɓ]
	VOID* pDSLockedBuffer		= NULL;
	DWORD dwDSLockedBufferSize	= 0;
    if( FAILED( hr = this->pDSBuffer->Lock( 0, dwSize, &pDSLockedBuffer, &dwDSLockedBufferSize, NULL, NULL, DSBLOCK_ENTIREBUFFER ) ) )
		return FDKERR_LockɎs;
	else
	{
		CopyMemory( pDSLockedBuffer, pData, dwSize );
		this->pDSBuffer->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
	}
	return S_OK;
}

HRESULT CSound::RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored )
{
    HRESULT hr;

	// `FbN
    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;
	
	if( pbWasRestored ) *pbWasRestored = FALSE;

	// Xe[^X Lost `FbN
    DWORD dwStatus;
    if( FAILED( hr = pDSB->GetStatus( &dwStatus ) ) )
        return hr;

    if( dwStatus & DSBSTATUS_BUFFERLOST )
    {
		// TEhobt@ Lost Ă̂ŕB
		// AvP[V͊΂̏ꍇA܂ DirectSound ͐䌠
		// nĂĂȂ߁Aobt@ Restore s邱ƂB
		// ȂADirectSound 䌠܂ŃX[vB
		while( ( hr = pDSB->Restore() ) == DSERR_BUFFERLOST )
			Sleep( 100 );

		// ł̓obt@̕Bf[^̓e͌Ăяoŕʓr邱ƁB

		if( pbWasRestored )	*pbWasRestored = TRUE;
	}
	return S_OK;
}

HRESULT	CSound::DecodeFromXA(  LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize )
{
	XAHEADER xah;
	HXASTREAM hxas;
	XASTREAMHEADER xash;
	UCHAR *ps;
	ULONG dlen;

	// wb_`FbN
	CopyMemory( &xah, pSrcData, sizeof(XAHEADER) );
	if( xah.id != _XAID )
		return FDKERR_SoundType;		// XA ł͂Ȃ

	ps = (UCHAR *)pSrcData + sizeof(XAHEADER);
	WAVEFORMATEX* pwfx = (WAVEFORMATEX*) malloc( sizeof(WAVEFORMATEX) );
	hxas = xaDecodeOpen( &xah, pwfx );
	if( hxas == NULL )
		return FDKERR_SoundType;		// XA ł͂Ȃ

	// fR[hTCY̎擾
	if( ! xaDecodeSize( hxas, xah.nDataLen, &dlen ) )
	{
		xaDecodeClose( hxas );
		return FDKERR_SoundType;		// XA ł͂ȂH
	}

	// fR[hTCỸm
	BYTE* pDestData = (LPBYTE) malloc( dlen );
	if( ! pDestData )
	{
		xaDecodeClose( hxas );
		return E_OUTOFMEMORY;		// s
	}

	// XA  WAV ϊ
	xash.pSrc = ps;
	xash.nSrcLen = xah.nDataLen;
	xash.nSrcUsed = 0;
	xash.pDst = (UCHAR *) pDestData;
	xash.nDstLen = dlen;
	xash.nDstUsed = 0;
	if( ! xaDecodeConvert( hxas, &xash ) )
	{
		xaDecodeClose( hxas );
		return FDKERR_SoundType;		// XA ł͂ȂH
	}

	// XA ϊ
	xaDecodeClose( hxas );

	// ̕ϊTCY̌vZ
//	lpSrcInfo->dwPCMSize = dlen;		// xadec ̃oO
	DWORD dwTrueLen = xah.nSamples * xah.nChannels * 2;

	// 쐬Ə
	HRESULT hr;
	if( FAILED( hr = CreateAndCopyBuffer( pDS, pwfx, pDestData, dwTrueLen ) ) )
	{
		SAFE_FREE( pwfx );
		SAFE_FREE( pDestData );
		return hr;
	}
	SAFE_FREE( pwfx );
	SAFE_FREE( pDestData );

	m_SoundType = SOUNDTYPE_XA;

	return S_OK;
}

HRESULT	CSound::DecodeFromMP3( LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize )
{
	// wb_`FbN
	if( dwSrcSize <= 128 )
		return FDKERR_SoundType;		// MP3Ȃ

	//  ID3v2^OĂȂ΁Aǂݔ΂
	if( (pSrcData[0] == 'I') && (pSrcData[1] == 'D') && (pSrcData[2] == '3') )
	{
		DWORD dwID3Size = pSrcData[9] + (pSrcData[8]<<7) + (pSrcData[7]<<14) + (pSrcData[6]<<21);
		if( pSrcData[3] >= 0x04)
		{
			if( pSrcData[5] & 0x10 )
				dwID3Size += 20; // ID3v2.4.0ȍ~Etb^
			else
				dwID3Size += 10; // ID3v2.4.0ȍ~Etb^Ȃ
		}
		else
			dwID3Size += 10;	 // ID3v2.3.0ȑOEtb^Ȃ
		
		if( dwSrcSize <= dwID3Size + 128 )
			return FDKERR_SoundType;		// MP3Ȃ

		pSrcData += dwID3Size;
		dwSrcSize -= dwID3Size;
	}

	//	MP3`FbN
	if( pSrcData[0] != 0xff || (pSrcData[1] & 0xf0) != 0xf0 )
		return FDKERR_SoundType;		// MP3Ȃ


	static const int anBitrate[2][3][16] = {
		{
			// MPEG-1
			{ 0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,0 },	//	32000Hz(layer1)
			{ 0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,0 },	//	44100Hz(layer2)
			{ 0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,0 },	//	48000Hz(layer3)
		},
		{
			// MPEG-2, 2.5
			{ 0,32,48,56, 64, 80, 96,112,128,144,160,176,192,224,256,0 },	//	32000Hz(layer1)
			{ 0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0 },	//	44100Hz(layer2)
			{ 0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0 },	//	48000Hz(layer3)
			},
	};
	static const int anFreq[2][4] = {
		{ 44100,48000,32000,0 },
		{ 22050,24000,16000,0 },
	};

	// C[ԍ̃`FbN
	int nLayer = 4-((pSrcData[1] >> 1) & 3);
	if( nLayer == 4 )
		return FDKERR_SoundType;			// MP3 ȂH
	
	int nMpeg		= ((pSrcData[1] & 8) == 0) ? 1 : 0;
	int nBitrate	= anBitrate[ nMpeg ][ nLayer-1 ][ pSrcData[2]>>4 ];
	int nFreq		= anFreq[ nMpeg ][ (pSrcData[2] >> 2) & 3];
	int nChannel	= ((pSrcData[3] >> 6) == 3) ? 1 : 2;
	int nFrameSize	= 144000 * nBitrate / nFreq;

	// MP3̃^Opӂ
	MPEGLAYER3WAVEFORMAT wfxMP3;
	ZeroMemory( &wfxMP3, sizeof(MPEGLAYER3WAVEFORMAT) );
	wfxMP3.wfx.cbSize			= MPEGLAYER3_WFX_EXTRA_BYTES;
	wfxMP3.wfx.wFormatTag		= WAVE_FORMAT_MPEGLAYER3;
	wfxMP3.wfx.nChannels		= nChannel;
	wfxMP3.wfx.nSamplesPerSec	= nFreq;
	wfxMP3.wfx.nAvgBytesPerSec	= nBitrate * 1000 / 8;
	wfxMP3.wfx.nBlockAlign		= 1;
	wfxMP3.wfx.wBitsPerSample	= 0;
	wfxMP3.wID					= MPEGLAYER3_ID_MPEG;
	wfxMP3.fdwFlags				= MPEGLAYER3_FLAG_PADDING_OFF;
	wfxMP3.nBlockSize			= nFrameSize;
	wfxMP3.nFramesPerBlock		= 1;
	wfxMP3.nCodecDelay			= 0x0571;

	//	ID3^OĂȂ΁A̕O
	if( (pSrcData[ dwSrcSize-128 ] == 'T') && (pSrcData[ dwSrcSize-127 ] == 'A') && (pSrcData[ dwSrcSize-126 ] == 'G') )
		dwSrcSize-= 128;

	// \[X PCM ɕϊ\ codec 邩ׁAwfxDest ݒ
	MMRESULT mmr;
	WAVEFORMATEX wfxDest;
	wfxDest.wFormatTag = WAVE_FORMAT_PCM;
	if( ( mmr = acmFormatSuggest( NULL, (WAVEFORMATEX*)(&wfxMP3), &wfxDest, sizeof(WAVEFORMATEX), ACM_FORMATSUGGESTF_WFORMATTAG ) ) != 0 )
		return FDKERR_SoundType;		// Error: CODEC Ȃ

	BYTE* pDestData = NULL;
	DWORD dwDestSize = 0;

	// ACM I[v
	HACMSTREAM hAcm;
	if( ( mmr = acmStreamOpen( &hAcm, NULL, (WAVEFORMATEX*)(&wfxMP3), &wfxDest, NULL, NULL, NULL, ACM_STREAMOPENF_NONREALTIME ) ) != 0 )
		return FDKERR_SoundType;		// Error: I[vs

	// ϊ̃TCY擾AdwDestSize ɐݒ
	if( ( mmr = acmStreamSize( hAcm, dwSrcSize, &dwDestSize, ACM_STREAMSIZEF_SOURCE ) ) != 0 )
	{
		acmStreamClose( hAcm, NULL );
		return FDKERR_SoundType;		// Error: TCY擾s
	}
	if( dwDestSize == 0 )
	{
		acmStreamClose( hAcm, NULL );
		return FDKERR_SoundType;		// Error: ϊ̃TCY[
	}

	// PCMobt@̊m
	pDestData = (LPBYTE) malloc( dwDestSize );
	if( ! pDestData ) 
	{
		acmStreamClose( hAcm, NULL );
		return E_OUTOFMEMORY;				// Error: s
	}

	// ϊpwb_
	ACMSTREAMHEADER	acmHeader;
	ZeroMemory( &acmHeader, sizeof(acmHeader) );
	acmHeader.cbStruct		= sizeof(acmHeader);
	acmHeader.pbSrc			= pSrcData;
	acmHeader.cbSrcLength	= dwSrcSize;
	acmHeader.pbDst			= pDestData;
	acmHeader.cbDstLength	= dwDestSize;
	if( ( mmr = acmStreamPrepareHeader( hAcm, &acmHeader, NULL ) ) != 0 )
	{
		acmStreamUnprepareHeader( hAcm, &acmHeader, NULL );
		acmStreamClose( hAcm, NULL );
		SAFE_FREE( pDestData );
		return FDKERR_SoundType;		// ACMwb_o^s
	}

	// ϊ
	if( ( mmr = acmStreamConvert( hAcm, &acmHeader, NULL ) ) != 0 )
	{
		acmStreamUnprepareHeader( hAcm, &acmHeader, NULL );
		acmStreamClose( hAcm, NULL );
		SAFE_FREE( pDestData );
		return FDKERR_SoundType;		// ACMϊs
	}

	// ^̕ϊTCY擾
	dwDestSize = acmHeader.cbDstLengthUsed;

	// ACM 
	acmStreamUnprepareHeader( hAcm, &acmHeader, NULL );
	acmStreamClose( hAcm, NULL );

	// 쐬Ə
	HRESULT hr;
	if( FAILED( hr = CreateAndCopyBuffer( pDS, &wfxDest, pDestData, dwDestSize ) ) )
	{
		SAFE_FREE( pDestData );
		return hr;
	}
	SAFE_FREE( pDestData );
	
	m_SoundType = SOUNDTYPE_MP3;

	return S_OK;
}

HRESULT	CSound::DecodeFromWAV( LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize )
{
	MMRESULT mmr;

	// `FbN
	MMIOINFO mmio;
	ZeroMemory( &mmio, sizeof(MMIOINFO) );
	mmio.pchBuffer = (LPSTR)pSrcData;
	mmio.fccIOProc = FOURCC_MEM;
	mmio.cchBuffer = dwSrcSize;

	HMMIO hmmio;
	if( ( hmmio = mmioOpen( NULL, &mmio, MMIO_READ ) ) == NULL )	// MMIOI[v
		return FDKERR_SoundType;		// RIFF ł͂Ȃ

	// WAVE`Nֈړ
	MMCKINFO ckiParent;
	ckiParent.fccType = mmioFOURCC('W','A','V','E');
	if( ( mmr = mmioDescend( hmmio, &ckiParent, NULL, MMIO_FINDRIFF ) ) != 0 )
	{
		mmioClose( hmmio, 0 );
		return FDKERR_SoundType;		// WAVE`Nړs
	}

	// WAVEfmt`Nւ̈ړ
	MMCKINFO ckiChild;
	ckiChild.ckid = mmioFOURCC('f','m','t',' ');
	if( ( mmr = mmioDescend( hmmio, &ckiChild, &ckiParent, MMIO_FINDCHUNK ) ) != 0 )
	{
		mmioClose( hmmio, 0 );
		return FDKERR_SoundType;		// fmt `Nړs
	}

	// WAVEFORMATEX 擾Afmt`N甲
	WAVEFORMATEX* pw = (WAVEFORMATEX *) (((LPBYTE)pSrcData) + ((int)mmioSeek( hmmio, 0, SEEK_CUR )) );
	if( ( mmr = mmioAscend( hmmio, &ckiChild, 0 ) ) != MMSYSERR_NOERROR )
	{
		mmioClose( hmmio, 0 );
		return FDKERR_SoundType;		// fmt `NEos
	}

	// WAVEFORMATEX V malloc ̈ɕʂ
	WORD wfxsize = sizeof(WAVEFORMATEX) + ( ( pw->wFormatTag != WAVE_FORMAT_PCM ) ? pw->cbSize : 0 );
	WAVEFORMATEX* pwfx = (WAVEFORMATEX*) malloc( wfxsize );
	if( ! pwfx )
	{
		mmioClose( hmmio, 0 );
		return E_OUTOFMEMORY;				// s
	}
	CopyMemory( pwfx, pw, wfxsize );

	// data`Nֈړ
	ckiChild.ckid = mmioFOURCC('d','a','t','a');
	if( ( mmr = mmioDescend( hmmio, &ckiChild, &ckiParent, MMIO_FINDCHUNK ) ) != 0 )
	{
		mmioClose( hmmio, 0 );
		SAFE_FREE( pwfx );
		return FDKERR_SoundType;		// data`Nւ̈ړs
	}

	// TCYƃ|C^擾AMMIO
	BYTE* pDestData = (LPBYTE) ((LPBYTE)pSrcData + mmioSeek( hmmio, 0, SEEK_CUR ) );
	DWORD dwDestSize = ckiChild.cksize;
	mmioClose( hmmio, 0 );

	/* ܂łŁApwfx, pDestData, dwDestSize  RiffWAV ̓eꂽB*/

	// WAVE tH[}bgłȂꍇ ACM ŃfR[h
	if( pwfx->wFormatTag != WAVE_FORMAT_PCM )
	{
		WAVEFORMATEX* pSrcWfx	= pwfx;
		BYTE* pSrcData			= pDestData;
		DWORD dwSrcSize			= dwDestSize;

		// \[X PCM ɕϊ\ codec 邩ׁAwfxDest ݒ
		WAVEFORMATEX wfxDest;
		wfxDest.wFormatTag = WAVE_FORMAT_PCM;
		if( ( mmr = acmFormatSuggest( NULL, pSrcWfx, &wfxDest, sizeof(WAVEFORMATEX), ACM_FORMATSUGGESTF_WFORMATTAG ) ) != 0 )
		{
			SAFE_FREE( pSrcWfx );
			return FDKERR_SoundType;		// CODEC Ȃ
		}


		// ACM I[v
		HACMSTREAM hAcm;
		if( ( mmr = acmStreamOpen( &hAcm, NULL, pSrcWfx, &wfxDest, NULL, NULL, NULL, ACM_STREAMOPENF_NONREALTIME ) ) != 0 )
		{
			SAFE_FREE( pSrcWfx );
			return FDKERR_SoundType;		// ACM̃I[vɎs
		}

		// ϊ̃TCY擾AdwDestSize ɐݒ
		if( ( mmr = acmStreamSize( hAcm, dwSrcSize, &dwDestSize, ACM_STREAMSIZEF_SOURCE ) ) != 0 )
		{
			acmStreamClose( hAcm, NULL );
			SAFE_FREE( pSrcWfx );
			return FDKERR_SoundType;		// ϊ̃TCY̎擾Ɏs
		}
		if( dwDestSize == 0 )
		{
			acmStreamClose( hAcm, NULL );
			SAFE_FREE( pSrcWfx );
			return FDKERR_SoundType;		// ϊ̃TCY[
		}

		// ϊtH[}bg̎擾ݒ
		pwfx = (WAVEFORMATEX*) malloc( sizeof(WAVEFORMATEX) );
		if( ! pwfx )
		{
			acmStreamClose( hAcm, NULL );
			SAFE_FREE( pSrcWfx );
			return E_OUTOFMEMORY;				// s
		}
		CopyMemory( pwfx, &wfxDest, sizeof(WAVEFORMATEX) );

		// PCMobt@̊m
		pDestData = (LPBYTE) malloc( dwDestSize );
		if( ! pDestData )
		{
			acmStreamClose( hAcm, NULL );
			SAFE_FREE( pSrcWfx );
			return E_OUTOFMEMORY;				// s
		}

		// ϊpwb_
		ACMSTREAMHEADER	acmHeader;
		ZeroMemory( &acmHeader, sizeof(acmHeader) );
		acmHeader.cbStruct		= sizeof(acmHeader);
		acmHeader.pbSrc			= pSrcData;
		acmHeader.cbSrcLength	= dwSrcSize;
		acmHeader.pbDst			= pDestData;
		acmHeader.cbDstLength	= dwDestSize;
		if( ( mmr = acmStreamPrepareHeader( hAcm, &acmHeader, NULL ) ) != 0 )
		{
			acmStreamUnprepareHeader( hAcm, &acmHeader, NULL );
			acmStreamClose( hAcm, NULL );
			SAFE_FREE( pSrcWfx );
			SAFE_FREE( pwfx );
			SAFE_FREE( pDestData );
			return FDKERR_SoundType;		// ACMwb_o^s
		}

		// ϊ
		if( ( mmr = acmStreamConvert( hAcm, &acmHeader, NULL ) ) != 0 )
		{
			acmStreamUnprepareHeader( hAcm, &acmHeader, NULL );
			acmStreamClose( hAcm, NULL );
			SAFE_FREE( pSrcWfx );
			SAFE_FREE( pwfx );
			SAFE_FREE( pDestData );
			return FDKERR_SoundType;		// ACMϊs
		}

		// ^̕ϊTCY擾
		dwDestSize = acmHeader.cbDstLengthUsed;

		// ACM 
		acmStreamUnprepareHeader( hAcm, &acmHeader, NULL );
		acmStreamClose( hAcm, NULL );

		// 쐬Ə
		HRESULT hr;
		if( FAILED( hr = CreateAndCopyBuffer( pDS, pwfx, pDestData, dwDestSize ) ) )
		{
			SAFE_FREE( pwfx );
			SAFE_FREE( pSrcWfx );
			SAFE_FREE( pDestData );
			return hr;
		}
		SAFE_FREE( pwfx );
		SAFE_FREE( pSrcWfx );
		SAFE_FREE( pDestData );
	}
	else
	{
		// 쐬Ə
		HRESULT hr;
		if( FAILED( hr = CreateAndCopyBuffer( pDS, pwfx, pDestData, dwDestSize ) ) )
		{
			SAFE_FREE( pwfx );
			return hr;
		}
		SAFE_FREE( pwfx );
	}

	m_SoundType = SOUNDTYPE_WAV;

	return S_OK;
}

HRESULT	CSound::DecodeFromOgg( LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize )
{
	COgg ogg;

	// `FbN
	if( ! ogg.Init( pSrcData, dwSrcSize ) )
		return FDKERR_SoundType;		// Ogg Ȃ

	// fR[hobt@̊m
	size_t szDestDataSize = ogg.GetDestSize();
	if( szDestDataSize == 0 )
		return FDKERR_SoundType;

	LPBYTE pDestData = (LPBYTE) malloc( szDestDataSize );
	if( ! pDestData )
	{
		ogg.Term();
		return E_OUTOFMEMORY;				// s
	}
	
	// fR[h
	if( ! ogg.ConvertToWav( pDestData, szDestDataSize ) )
	{
		ogg.Term();
		SAFE_FREE( pDestData );
		return FDKERR_SoundType;		// ϊs
	}

	// WAVEtH[}bg̎擾
	WAVEFORMATEX wfx;
	if( ! ogg.GetFormat( &wfx ) )
	{
		ogg.Term();
		SAFE_FREE( pDestData );
		return FDKERR_SoundType;		// 擾s
	}

	// TEh̍쐬Ə
	HRESULT hr;
	if( FAILED( hr = CreateAndCopyBuffer( pDS, &wfx, pDestData, (DWORD)szDestDataSize ) ) )
	{
		ogg.Term();
		SAFE_FREE( pDestData );
		return hr;
	}

	// 
	SAFE_FREE( pDestData );
	ogg.Term();

	m_SoundType = SOUNDTYPE_OGG;

	return S_OK;
}

void	CSound::Play( bool bLoop )
{
	HRESULT hr;

	// `FbN
	if( this->pDSBuffer == NULL )
		return;		// ZJ_obt@

	// TEhobt@̃XgA`FbN
	BOOL bRestored = FALSE;
    if( FAILED( hr = this->RestoreBuffer( this->pDSBuffer, &bRestored ) ) )
		return;		// TEhobt@̕Ɏs
	if( bRestored )
	{
		Term();
		TCHAR filename[_MAX_PATH];
		lstrcpyn( filename, this->strFileName, _MAX_PATH );
		if( FAILED( hr = CreateFromFile( CSoundManager::GetDirectSound(), filename ) ) )
			return;	// TEhobt@̕Ɏs
	}

	// ĐJnʒǔ
	DWORD dwStartPos = (m_SoundType == SOUNDTYPE_MP3) ? GetPositionFromTime( CSoundManager::dbMP3Đxms ) : 0;

	// ĐJ[\
	DWORD dwStatus;
	this->pDSBuffer->SetCurrentPosition( dwStartPos );
	this->pDSBuffer->GetStatus( &dwStatus );
	if( dwStatus & DSBSTATUS_PLAYING )
	{
		this->pDSBuffer->Stop();
		this->pDSBuffer->SetCurrentPosition( dwStartPos );
	}

	// Đ
	DWORD dwFreq;
	this->pDSBuffer->SetFrequency( DSBFREQUENCY_ORIGINAL );
	this->pDSBuffer->GetFrequency( &dwFreq );
	this->pDSBuffer->SetFrequency( (DWORD)(dwFreq * this->fSpeed * this->fPitch ) );
	this->pDSBuffer->SetVolume( this->lVolume );
	this->pDSBuffer->SetPan( this->lPan );
	this->pDSBuffer->Play( 0, 0, (bLoop) ? DSBPLAY_LOOPING : 0 );

	this->bLoop = bLoop;
	this->nPause = 0;
}

void	CSound::Stop()
{
	if( this->pDSBuffer )
	{
		this->pDSBuffer->Stop();
		this->pDSBuffer->SetCurrentPosition( 0 );
		this->nPause = 0;
	}
}

void	CSound::Pause()
{
	if( this->pDSBuffer && IsPlay() )
	{
		this->pDSBuffer->GetCurrentPosition( &this->dwCurrentPosition, NULL );
		this->pDSBuffer->Stop();
		this->nPause ++;
	}
}

void	CSound::Cont()
{
	if( this->nPause == 0 )
		return;
	this->nPause --;

	HRESULT hr;

	// `FbN
	if( this->pDSBuffer == NULL )
		return;	// ZJ_obt@

	// TEhobt@̃XgA`FbN
	BOOL bRestored = FALSE;
    if( FAILED( hr = RestoreBuffer( this->pDSBuffer, &bRestored ) ) )
		return;	// TEhobt@̕Ɏs
	if( bRestored )
	{
		Term();
		TCHAR	filename[_MAX_PATH];
		lstrcpyn( filename, this->strFileName, _MAX_PATH );
		if( FAILED( hr = CreateFromFile( CSoundManager::GetDirectSound(), filename ) ) )
			return;	// TEhobt@̕Ɏs
	}

	// ĐJnʒǔ
	DWORD dwStartPos = this->dwCurrentPosition;

	// ĐJ[\
	DWORD dwStatus;
	this->pDSBuffer->SetCurrentPosition( dwStartPos );
	this->pDSBuffer->GetStatus( &dwStatus );
	if( dwStatus & DSBSTATUS_PLAYING )
	{
		this->pDSBuffer->Stop();
		this->pDSBuffer->SetCurrentPosition( dwStartPos );
	}

	// Đ
	DWORD dwFreq;
	this->pDSBuffer->SetFrequency( DSBFREQUENCY_ORIGINAL );
	this->pDSBuffer->GetFrequency( &dwFreq );
	this->pDSBuffer->SetFrequency( (DWORD)(dwFreq * this->fSpeed * this->fPitch ) );
	this->pDSBuffer->SetVolume( this->lVolume );
	this->pDSBuffer->SetPan( this->lPan );
	this->pDSBuffer->Play( 0, 0, (this->bLoop) ? DSBPLAY_LOOPING : 0 );
}

void	CSound::Cont( double dbContTime )
{
	// J[\ړ(this->dwCurrentPositionړ)
	SetPosition( GetPositionFromTime( dbContTime ) );
	
	// this->dwCurrentPosition ĊJ
	Cont();
}

void	CSound::SetPosition( DWORD dwNewPosition )
{
	if( ! this->pDSBuffer )
		return;

	// ubNEɂ낦
	DWORD dwSize;
	this->pDSBuffer->GetFormat( NULL, 0, &dwSize );
	WAVEFORMATEX* pWF = (LPWAVEFORMATEX) malloc( dwSize );
	this->pDSBuffer->GetFormat( pWF, dwSize, NULL );
	dwNewPosition -= dwNewPosition % pWF->nBlockAlign;

	// J[\ړ
	DSBCAPS dsbc;
	ZeroMemory( &dsbc, sizeof(dsbc) );
	dsbc.dwSize = sizeof(DSBCAPS);
	this->pDSBuffer->GetCaps( &dsbc );
	if( dwNewPosition < dsbc.dwBufferBytes )
		this->pDSBuffer->SetCurrentPosition( dwNewPosition );

	this->dwCurrentPosition = dwNewPosition;	// ꉞf...
	free( pWF );
}

DWORD	CSound::GetPositionFromTime( double dbTime )
{
	if( ! this->pDSBuffer )
		return 0;

	// gXs[h
	dbTime = dbTime * this->fSpeed * this->fPitch;

	// MP3 ȂAdwTime ɒxԂZB
	if( m_SoundType == SOUNDTYPE_MP3 ) 
		dbTime += CSoundManager::dbMP3Đxms;

	// dbTime [ms]  dwCurPos [byte] Zo
	DWORD dwCurPos, dwSize;
	this->pDSBuffer->GetFormat( NULL, 0, &dwSize );
	WAVEFORMATEX* pWF = (LPWAVEFORMATEX) malloc( dwSize );
	this->pDSBuffer->GetFormat( pWF, dwSize, NULL );
	dwCurPos = (DWORD)(dbTime * 0.001 * (pWF->nSamplesPerSec/* * this->fSpeedw*/) * pWF->nBlockAlign);	//pWF->nAvgBytesPerSec ͏lԂƂAvZł̓I[o[t[̂Œ

	// ubNEɂ낦
	dwCurPos -= dwCurPos % pWF->nBlockAlign;

	free( pWF );
	return dwCurPos;
}

void	CSound::SetVolume( long lVolume )
{
	if( lVolume == 0 )
		lVolume = 1;		// Vol = 0 ͂Ȃ100%ɂȂĂ܂...

	this->lVolume = (long)(( 20.0 * log10( lVolume / 100.0 ) ) * 100.0);

	// tȂ瑦f
	if( IsPlay() )
		this->pDSBuffer->SetVolume( this->lVolume );
}

void	CSound::SetPan( long lPan )
{
	if( lPan == 0 ) this->lPan = 0;
	else if( lPan == -100 ) this->lPan = DSBPAN_LEFT;
	else if( lPan ==  100 ) this->lPan = DSBPAN_RIGHT;
	else if( lPan < 0 ) this->lPan = (long)( (20.0 * log10((lPan+100)/100.0)) * 100.0 );
	else this->lPan = (long)( (-20.0 * log10((100-lPan)/100.0)) * 100.0 );

	// tȂ瑦f
	if( IsPlay() )
		this->pDSBuffer->SetPan( lPan );
}

bool	CSound::IsPlay()
{
	if( ! this->pDSBuffer )
		return false;

	DWORD dwStatus;
	this->pDSBuffer->GetStatus( &dwStatus );
	return dwStatus & DSBSTATUS_PLAYING;
}

DWORD	CSound::GetFrequency()
{
	if( ! this->pDSBuffer )
		return 0;

	DWORD dwFreq;
	this->pDSBuffer->GetFrequency( &dwFreq );
	return dwFreq;
}

DWORD	CSound::SetFrequency( DWORD dwFreq )
{
	if( ! this->pDSBuffer )
		return 0;

	DWORD dwOldFreq;
	this->pDSBuffer->GetFrequency( &dwOldFreq );
	this->pDSBuffer->SetFrequency( dwFreq );
	return dwOldFreq;
}

double	CSound::GetTotalTime()
{
	if( this->pDSBuffer == NULL )
		return 0.0;

	// WAVEFORMATEX 擾
	DWORD dwSize;
	this->pDSBuffer->GetFormat( NULL, 0, &dwSize );
	LPWAVEFORMATEX pWF = (LPWAVEFORMATEX) malloc( dwSize );
	this->pDSBuffer->GetFormat( pWF, dwSize, NULL );

	// Ԃ̌vZ
	double dbTotalTime = (double)( this->dwDSBufferSize / ( pWF->nAvgBytesPerSec * 0.001 ) );

	free( pWF );
	return dbTotalTime;
}

	}//Sound
}//FDK