#include "stdafx.h"
#include <nlite_common\nexception.h>
#include "iecookiegetter.h"
#include "firefoxcookiegetter.h"
#include "iecomponentcookiegetter.h"
#include "chromecookiegetter.h"
#include "safaricookiegetter.h"
#include "operacookiegetter.h"
#include "cookiemaster.h"



#include "namespace_start.h"



Bool CCookieMaster::GetCookie(browsertype::BrowserType bt,const NString &domein,const NString &name,CCookie &cookie){

	Bool result = false;
	switch(bt){

		case browsertype::IE:
			{
				CIECookieGetter iecookie;
				result = iecookie.GetCookie(domein,name,cookie);

			}
			break;
		case browsertype::FIREFOX:
			{
				CFireFoxCookieGetter firefoxcookie;
				result = firefoxcookie.GetCookie(domein,name,cookie);

			}
			break;
		case browsertype::CHROME:
			{
				CChromeCookieGetter chromecookie;
				result = chromecookie.GetCookie(domein,name,cookie);

			}
			break;
		case browsertype::SAFARI:
			{
				CSafariCookieGetter safaricookie;
				result = safaricookie.GetCookie(domein,name,cookie);

			}
			break;

		case browsertype::OPERA:
			{
				COperaCookieGetter operacookie;
				result = operacookie.GetCookie(domein,name,cookie);

			}
			break;
		case browsertype::IECOMPONENT:
			{
				CIEComponentGetter iecomcookie;
				result = iecomcookie.GetCookie(domein,name,cookie);
			}
			break;
		case browsertype::UNDEFINED:
			{

				THROW_EXCEPTION(Exception,_T("NbL[擾Ɏw肳ꂽuEU̎ނ`ł"));

			}
			break;
		default:
			{
				THROW_EXCEPTION(Exception,_T("NbL[擾Ɏw肳ꂽuEU̎ނsȒlł"));
				

			}
			break;
	}
	
	return result;
}


const NChar *CCookieMaster::BrowserTypeToString(browsertype::BrowserType bt){

	switch(bt){
		case browsertype::IE: return _T("IE");
		case browsertype::FIREFOX:return _T("FireFox");
		case browsertype::CHROME:return _T("Chrome");
		case browsertype::SAFARI:return _T("Safari");
		case browsertype::OPERA:return _T("Opera");
		case browsertype::IECOMPONENT:return _T("IEComponent");
		case browsertype::UNDEFINED:return _T("UnDefined");

		default:return _T("UnKnown");

	}

}

const NChar *CCookieMaster::ResultCodeToString(resultcode::ResultCode rc){
	switch(rc){
		case resultcode::OK:return _T("OK");
		case resultcode::ERR_SQLITE:return _T("Err_Sqlite");
		case resultcode::ERR_IEAPI:return _T("Err_IE"); 
		case resultcode::ERR_IEAPI_SEC:return _T("Err_IESec");
		case resultcode::UNDEFINED :return _T("Undefined");
		
		default:return _T("UnKnown");
	}
}


#include "namespace_end.h"