#pragma once

#include <nlite_common\define.h>
#include <nlite_common\windowsAPI.h>
#include <iepmapi.h>
#include <WinInet.h>
#include "cookieGetter.h"


#include "namespace_start.h"
template<typename T>
class CIEAPICookieGetterT:public CCookieGetterT<T>{

protected :
	NString normalDirectry;

public:

	CIEAPICookieGetterT(){

		GetCookieDirectry(normalDirectry);

	}

protected:

	
	CCookieGetResult GetCookieIEAPI(const NString &domein,const NString &name,CCookie &cookie,Bool securytyFlag,DWORD flags = 0){

		std::vector<NChar> buf;
		buf.resize(4096);
		CCookieGetResult result(BT);
		DWORD dwCookieBufSize = buf.size();
		CHResult hresult;
		NString url = _T("http://") + domein;
		if(securytyFlag){

			hresult = IEGetProtectedModeCookie(url.c_str(),name.c_str(),&buf[0],&dwCookieBufSize,flags);

		} else if(InternetGetCookie(url.c_str(),name.c_str(),&buf[0],&dwCookieBufSize)){

			hresult = S_OK;

		} else {

			hresult = GetLastError();

		}

		
		if(hresult.IsSucceded()){

			NString val = buf.data();
			nregex reg(name + _T("="));
			val = std::regex_replace(val,reg,NString(_T("")));
			cookie.SetCookieValue(val);
			result.SetFindFlag(true);
			result.SetResultCode(resultcode::OK);
		} else {

			
			result.SetResultCode(securytyFlag  ? resultcode::ERR_IEAPI_SEC : resultcode::ERR_IEAPI);
			result.SetHResult(hresult);
		

		}

		return result;

	}

protected:

	static Bool Fancta(const Byte * data,ULong dataSize,const NString & domein,const NString &name,CCookie &cookie){


		MString mname;
		MString mdomein;
		ToUTF8(mname,name);
		ToUTF8(mdomein,domein);

		const Char *keyStartPointer = strstr(reinterpret_cast<const Char*>(data),mname.c_str());

		if(keyStartPointer == nullptr)return false;
		const Char *cookieStartPointer = strstr(keyStartPointer,"\n");

		if(cookieStartPointer == nullptr)return false;

		cookieStartPointer++;

		const Char *cookieEndPointer = strstr(cookieStartPointer,"\n");

		const Char *astorStartPointer = strstr(cookieEndPointer+1,"*");
		const Char *domeinStartPointer = strstr(cookieEndPointer+1,mdomein.c_str());
		if(astorStartPointer == nullptr || domeinStartPointer == nullptr || astorStartPointer <= domeinStartPointer)return false;
		Int cookieBufSize = cookieEndPointer - cookieStartPointer;
		U16String val;
		UTF8ToUTF16(val,cookieStartPointer,cookieBufSize);
		cookie.SetCookieValue(val);
		
		return true;
	}

	template<typename F>
	CCookieGetResult ForceSearchFiles(const NString &cookieDir,const NString &domein,const NString &name,CCookie &cookie,F func){

		CCookieGetResult result(BT);
		CFindFirstFile findfirst;
		NString searchFiles = cookieDir + _T("\\?*.txt");
		NString targetFileName;
		WIN32_FIND_DATA findData;
		
		if(findfirst.Find(searchFiles,findData) == INVALID_HANDLE_VALUE)return result;

		do{
			
		
			if((findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == false){
			
				targetFileName = (cookieDir + _T("\\")) + findData.cFileName;

				if(ForceSearch(targetFileName,domein,name,cookie,func)){

					result.SetFindFlag(true);
					break;
				}
			}

		}while(findfirst.NextFile(findData));


		

		return result;
	}



	


	

};

#include "namespace_end.h"


#pragma comment(lib,"WinInet.lib")
#pragma comment(lib,"iepmapi.lib")