/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata;

import java.util.HashMap;
import java.util.Map;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.AutomataOperations;
import jdd.des.automata.Automaton;
import jdd.des.automata.AutomatonException;
import jdd.des.automata.Event;
import jdd.des.automata.ReachabilityTool;
import jdd.des.automata.State;
import jdd.util.Test;
import jdd.util.sets.Set;

public class AutomataComposer
extends ReachabilityTool {
    private static final double MAX_COMPOSE_SIZE = Math.pow(2.0, 24.0);
    private Automaton answer;
    private Automata target;
    private Event[] answer_events;
    private StringBuffer sb_int = new StringBuffer();
    private Map name_map = new HashMap();

    public AutomataComposer(Automata automata) throws AutomatonException {
        this(automata, AutomataOperations.asArray(automata));
    }

    public AutomataComposer(Automata automata, Automaton[] automatonArray) throws AutomatonException {
        super(automatonArray);
        this.answer = automata.add(AutomataOperations.getSafeName(automata, "Composition"));
        this.answer_events = new Event[this.alphabet_size];
        for (int i = 0; i < this.alphabet_size; ++i) {
            this.answer_events[i] = this.answer.addEvent(this.alphabet[i].getLabel(), this.alphabet[i].isControllable());
        }
        this.compose();
    }

    private void compose() throws AutomatonException {
        Set set = this.univ.createEmptySet();
        int[] nArray = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            nArray[i] = AutomataOperations.getInitialState((Automaton)this.automata[i]).extraindex;
        }
        set.insert(nArray);
        this.g_r = set;
        this.traverse_and_compose(nArray);
        this.g_r = null;
        set.free();
    }

    protected State traverse_and_compose(int[] nArray) {
        int[] nArray2 = new int[this.size];
        State state = this.createState(nArray);
        for (int i = 0; i < this.alphabet_size; ++i) {
            Object object;
            if (!this.elig(nArray, nArray2, i)) continue;
            if (!this.g_r.member(nArray2)) {
                this.g_r.insert(nArray2);
                object = this.traverse_and_compose(nArray2);
                this.answer.addTransition(state, (State)object, this.answer_events[i]);
                continue;
            }
            object = this.createName(nArray2);
            State state2 = (State)this.name_map.get(object);
            this.answer.addTransition(state, state2, this.answer_events[i]);
        }
        return state;
    }

    private String createName(int[] nArray) {
        StringBuffer stringBuffer = this.sb_int;
        stringBuffer.setLength(0);
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.map[i][nArray[i]].getLabel());
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    private State createState(int[] nArray) {
        String string = this.createName(nArray);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        for (int i = 0; i < this.size; ++i) {
            bl &= this.map[i][nArray[i]].isInitial();
            bl2 &= this.map[i][nArray[i]].isMarked();
            bl3 |= this.map[i][nArray[i]].isForbidden();
        }
        State state = this.answer.addState(string);
        state.setInitial(bl);
        state.setMarked(bl2);
        state.setForbidden(bl3);
        this.name_map.put(string, state);
        return state;
    }

    public double getActualSize() {
        return this.answer.numOfNodes();
    }

    public Automaton getComposition() {
        return this.answer;
    }

    public static void internal_test() {
        Test.start("AutomataComposer");
        try {
            Automata automata = AutomataIO.loadXML("data/phil.xml");
            AutomataComposer automataComposer = new AutomataComposer(automata);
            Automaton automaton = automataComposer.getComposition();
            Test.checkEquality(automaton.numOfNodes(), 19, "Q size ");
            Test.checkEquality(automaton.numOfEdges(), 30, "T size ");
            Test.checkEquality(automaton.getAlphabet().getSize(), 10, "E size ");
            automata = new Automata();
            for (int i = 0; i < 4; ++i) {
                automaton = automata.add("test" + i);
                Event event = automaton.addEvent("e" + i);
                State state = automaton.addState("s");
                state.setInitial(true);
                for (int j = 1; j < 6; ++j) {
                    State state2 = automaton.addState("q" + j);
                    automaton.addTransition(state, state2, event);
                    state = state2;
                }
            }
            automataComposer = new AutomataComposer(automata);
            automaton = automataComposer.getComposition();
            Test.checkEquality(automaton.numOfNodes(), (int)Math.pow(6.0, 4.0), "Q size ");
            Test.checkEquality(automaton.getAlphabet().getSize(), 4, "E size ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Test.check(false, exception.toString());
        }
        Test.end();
    }
}

