/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.Dot;
import jdd.util.JDDConsole;

public class GraphPrinter {
    public static void show(Node node) {
        JDDConsole.out.println("\nNode " + node.getLabel());
        Edge edge = node.firstIn;
        if (edge != null) {
            JDDConsole.out.print("Incoming arcs: ");
            while (edge != null) {
                JDDConsole.out.print(" " + edge.n1.getLabel());
                edge = edge.prev;
            }
            JDDConsole.out.println();
        }
        if ((edge = node.firstOut) != null) {
            JDDConsole.out.print("Outgoing arcs: ");
            while (edge != null) {
                JDDConsole.out.print(" " + edge.n2.getLabel());
                edge = edge.next;
            }
            JDDConsole.out.println();
        }
    }

    public static void show(Graph graph) {
        if (graph.isDirected()) {
            JDDConsole.out.println();
            Vector vector = graph.getNodes();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                JDDConsole.out.print("" + node.getLabel() + ":");
                Edge edge = node.firstOut;
                while (edge != null) {
                    JDDConsole.out.print(" " + edge.n2.getLabel());
                    if ((edge.flags & 4) != 0) {
                        JDDConsole.out.print("(" + edge.weight + ")");
                    }
                    edge = edge.next;
                }
                JDDConsole.out.println();
            }
        } else {
            Object object;
            JDDConsole.out.print("G = < (");
            boolean bl = true;
            Vector vector = graph.getNodes();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                if (bl) {
                    bl = false;
                } else {
                    JDDConsole.out.print(", ");
                }
                JDDConsole.out.print("" + ((Node)object).getLabel());
            }
            JDDConsole.out.print(") ,  (");
            vector = graph.getEdges();
            bl = true;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                if (bl) {
                    bl = false;
                } else {
                    JDDConsole.out.print(", ");
                }
                JDDConsole.out.print("[" + ((Edge)object).n1.getLabel() + "," + ((Edge)object).n2.getLabel() + "]");
            }
            JDDConsole.out.println(") >");
        }
    }

    public static void showDot(String string, Graph graph, boolean bl) {
        int n = 0;
        try {
            Object object;
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println(bl ? "digraph G {" : "graph G {");
            printStream.println("\tgraph [splines=true overlap=false];");
            if (Dot.scaleable()) {
                printStream.println("\tsize = \"7.5,20\";");
            }
            printStream.println("\tcenter = true;");
            Vector vector = graph.getNodes();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                printStream.print("\t" + ((Node)object).id + " [label=\"" + ((Node)object).getLabel() + "\",");
                if ((((Node)object).flags & 4) != 0) {
                    printStream.print("shape=box, ");
                }
                if ((((Node)object).flags & 2) != 0) {
                    printStream.print("style=filled, ");
                }
                printStream.println("height=0.3, width=0.3];");
                if (!bl || (((Node)object).flags & 1) == 0) continue;
                printStream.println("\tinit" + n + "[label=\"\", style=invis, height=0, width=0];");
                printStream.println("\tinit" + n + " -> " + ((Node)object).id + ";");
                ++n;
            }
            vector = graph.getEdges();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                if (bl) {
                    printStream.print("\t" + ((Edge)object).n1.id + " -> " + ((Edge)object).n2.id + " [");
                } else {
                    printStream.print("\t" + ((Edge)object).n1.id + " -- " + ((Edge)object).n2.id + " [");
                }
                if ((((Edge)object).flags & 1) != 0) {
                    printStream.print("style=bold,");
                }
                if ((((Edge)object).flags & 2) != 0) {
                    printStream.print("color=gray,");
                }
                printStream.print("label=\"" + ((Edge)object).getLabel());
                if ((((Edge)object).flags & 4) != 0) {
                    printStream.print(":" + ((Edge)object).weight);
                }
                printStream.println("\"];");
            }
            printStream.println("}\n");
            printStream.close();
            Dot.showDot(string);
        }
        catch (IOException iOException) {
            JDDConsole.out.println("GraphPrinter.showDot failed: " + iOException);
        }
    }
}

