/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.mixedradix;

import jdd.util.Test;
import jdd.util.mixedradix.MREnumeration;
import jdd.util.mixedradix.MRUniverse;
import jdd.util.sets.Set;
import jdd.util.sets.SetEnumeration;

public class MRSet
implements Set {
    private MRUniverse universe;
    int[] data;
    int data_size;
    int last_mask;

    public MRSet(MRUniverse mRUniverse, boolean bl) {
        this.init(mRUniverse);
        int n = bl ? -1 : 0;
        for (int i = 0; i < this.data_size; ++i) {
            this.data[i] = n;
        }
        int n2 = this.data_size - 1;
        this.data[n2] = this.data[n2] & this.last_mask;
    }

    public MRSet(MRSet mRSet, boolean bl) {
        this.init(mRSet.universe);
        if (bl) {
            for (int i = 0; i < this.data_size; ++i) {
                this.data[i] = ~mRSet.data[i];
            }
        } else {
            for (int i = 0; i < this.data_size; ++i) {
                this.data[i] = mRSet.data[i];
            }
        }
        int n = this.data_size - 1;
        this.data[n] = this.data[n] & this.last_mask;
    }

    private void init(MRUniverse mRUniverse) {
        this.universe = mRUniverse;
        this.data_size = (int)(1.0 + mRUniverse.domainSize() / 32.0);
        this.data = new int[this.data_size];
        int n = (int)((double)(this.data_size * 32) - mRUniverse.domainSize());
        this.last_mask = (int)((1L << 32 - n) - 1L);
    }

    @Override
    public Set union(Set set) {
        MRSet mRSet = new MRSet(this, false);
        int[] nArray = ((MRSet)set).data;
        for (int i = 0; i < this.data_size; ++i) {
            int n = i;
            mRSet.data[n] = mRSet.data[n] | nArray[i];
        }
        return mRSet;
    }

    @Override
    public Set intersection(Set set) {
        MRSet mRSet = new MRSet(this, false);
        int[] nArray = ((MRSet)set).data;
        for (int i = 0; i < this.data_size; ++i) {
            int n = i;
            mRSet.data[n] = mRSet.data[n] & nArray[i];
        }
        return mRSet;
    }

    @Override
    public Set diff(Set set) {
        MRSet mRSet = new MRSet(this, false);
        int[] nArray = ((MRSet)set).data;
        for (int i = 0; i < this.data_size; ++i) {
            int n = i;
            mRSet.data[n] = mRSet.data[n] & ~nArray[i];
        }
        return mRSet;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data_size; ++i) {
            this.data[i] = 0;
        }
    }

    @Override
    public Set invert() {
        return new MRSet(this, true);
    }

    @Override
    public Set copy() {
        return new MRSet(this, false);
    }

    @Override
    public void free() {
    }

    @Override
    public double cardinality() {
        double d = 0.0;
        int n = this.data_size - 1;
        this.data[n] = this.data[n] & this.last_mask;
        for (int i = 0; i < this.data_size; ++i) {
            if (this.data[i] == 0) continue;
            d += (double)this.countOnes(this.data[i]);
        }
        return d;
    }

    @Override
    public boolean insert(int[] nArray) {
        long l = this.universe.valueToIndex(nArray);
        return this.test_and_set(l);
    }

    @Override
    public boolean remove(int[] nArray) {
        long l = this.universe.valueToIndex(nArray);
        return this.test_and_remove(l);
    }

    @Override
    public boolean member(int[] nArray) {
        long l = this.universe.valueToIndex(nArray);
        return this.test(l);
    }

    @Override
    public boolean isEmpty() {
        if ((this.data[this.data_size - 1] & this.last_mask) != 0) {
            return false;
        }
        for (int i = 0; i < this.data_size - 1; ++i) {
            if (this.data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        if ((this.data[this.data_size - 1] & this.last_mask) != this.last_mask) {
            return false;
        }
        for (int i = 0; i < this.data_size - 1; ++i) {
            if (this.data[i] == -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Set set) {
        int[] nArray = ((MRSet)set).data;
        int n = 0;
        int n2 = this.data_size - 1;
        nArray[n2] = nArray[n2] & this.last_mask;
        int n3 = this.data_size - 1;
        this.data[n3] = this.data[n3] & this.last_mask;
        for (int i = 0; i < this.data_size; ++i) {
            int n4 = this.compare_one(this.data[i], nArray[i]);
            if (n4 == 0) continue;
            if (n == 0) {
                n = n4;
                continue;
            }
            if (n4 == n) continue;
            return Integer.MAX_VALUE;
        }
        return n;
    }

    private int compare_one(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        int n3 = n & n2;
        if (n3 == n) {
            return -1;
        }
        if (n3 == n2) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Set set) {
        int[] nArray = ((MRSet)set).data;
        int n = this.data_size - 1;
        nArray[n] = nArray[n] & this.last_mask;
        int n2 = this.data_size - 1;
        this.data[n2] = this.data[n2] & this.last_mask;
        for (int i = 0; i < this.data_size; ++i) {
            if (nArray[i] == this.data[i]) continue;
            return false;
        }
        return true;
    }

    private int countOnes(int n) {
        int n2 = 0;
        for (int i = 0; i < 32; ++i) {
            if ((n & 1 << i) == 0) continue;
            ++n2;
        }
        return n2;
    }

    private boolean test_and_set(long l) {
        int n = (int)(l >> 5);
        int n2 = 1 << (int)(l & 0x1FL);
        if ((this.data[n] & n2) != 0) {
            return false;
        }
        int n3 = n;
        this.data[n3] = this.data[n3] | n2;
        return true;
    }

    private boolean test_and_remove(long l) {
        int n = (int)(l >> 5);
        int n2 = 1 << (int)(l & 0x1FL);
        if ((this.data[n] & n2) == 0) {
            return false;
        }
        int n3 = n;
        this.data[n3] = this.data[n3] & ~n2;
        return true;
    }

    boolean test(long l) {
        int n = (int)(l >> 5);
        int n2 = 1 << (int)(l & 0x1FL);
        return (this.data[n] & n2) != 0;
    }

    @Override
    public SetEnumeration elements() {
        return new MREnumeration(this.universe, this);
    }

    public static void internal_test() {
        Test.start("MRSet");
        int[] nArray = new int[]{3, 4, 5, 2};
        MRUniverse mRUniverse = new MRUniverse(nArray);
        Set set = mRUniverse.createEmptySet();
        Set set2 = mRUniverse.createFullSet();
        int[] nArray2 = new int[4];
        nArray2[3] = 0;
        nArray2[2] = 0;
        nArray2[1] = 0;
        nArray2[0] = 0;
        Test.check(set.insert(nArray2), "v not in S1 before");
        Test.check(!set.insert(nArray2), "v in S1 after");
        Test.checkEquality(set.cardinality(), 1.0, "Cardinality 1 after inserting v");
        Test.check(set.member(nArray2), "v \\in S1");
        Test.check(set.remove(nArray2), "v removed from S1");
        Test.check(!set.member(nArray2), "v \\not\\in S1");
        Test.check(!set.remove(nArray2), "v already removed from S1 and not in S1 anymore");
        Test.checkEquality(set.cardinality(), 0.0, "S1 empty again");
        Test.check(set.isEmpty(), "S1 is empty");
        Test.check(!set2.isEmpty(), "S2 is not empty");
        Set set3 = set.invert();
        Test.check(set3.equals(set2), "(NOT  emptyset) = fullset");
        set3.free();
        Set set4 = set2.copy();
        Test.check(set4.equals(set2), "copy() test");
        set4.clear();
        Test.check(set4.equals(set), "clear() test");
        set4.free();
        Set set5 = mRUniverse.createEmptySet();
        Set set6 = mRUniverse.createEmptySet();
        Set set7 = mRUniverse.createEmptySet();
        nArray2[3] = 0;
        nArray2[2] = 0;
        nArray2[1] = 0;
        nArray2[0] = 0;
        set5.insert(nArray2);
        set7.insert(nArray2);
        nArray2[3] = 1;
        nArray2[2] = 1;
        nArray2[1] = 1;
        nArray2[0] = 1;
        set6.insert(nArray2);
        set7.insert(nArray2);
        Set set8 = set6.union(set5);
        Test.check(set8.equals(set7), "union() - test");
        set8.free();
        Set set9 = set7.diff(set6);
        Set set10 = set7.diff(set5);
        Test.check(set9.equals(set5), "diff() - test 1");
        Test.check(set10.equals(set6), "diff() - test 2");
        set9.free();
        set10.free();
        Set set11 = set7.intersection(set6);
        Set set12 = set7.intersection(set5);
        Test.check(set11.equals(set6), "intersection() - test 1");
        Test.check(set12.equals(set5), "intersection() - test 2");
        set11.free();
        set12.free();
        Test.checkEquality(set6.compare(set6), 0, "x1 = x1");
        Test.checkEquality(set7.compare(set6), 1, "x1  < x10");
        Test.checkEquality(set6.compare(set7), -1, "x10 > x1");
        Test.checkEquality(set7.compare(set5), 1, "x10 > x0");
        Test.checkEquality(set5.compare(set7), -1, "x0  < x0");
        Test.checkEquality(set6.compare(set5), Integer.MAX_VALUE, "x10 ?? x0");
        set.free();
        set2.free();
        Test.end();
    }
}

