/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.zip;

import java.io.InputStream;
import jdd.util.zip.MemoryChunk;

public class MemoryInputStream
extends InputStream {
    private MemoryChunk root;
    private MemoryChunk curr_read;
    private int pos;
    private int remaining;
    private int remaining_save;

    public MemoryInputStream(MemoryChunk memoryChunk) {
        this.root = this.curr_read = memoryChunk;
        this.pos = 0;
        this.remaining_save = this.remaining = memoryChunk.getSize();
    }

    public void free() {
        if (this.root != null) {
            this.root.free();
        }
        this.curr_read = null;
        this.root = null;
    }

    @Override
    public int available() {
        return this.remaining;
    }

    @Override
    public void reset() {
        this.curr_read = this.root;
        this.pos = 0;
        this.remaining = this.remaining_save;
    }

    @Override
    public int read() {
        while (this.pos >= this.curr_read.curr) {
            if (this.curr_read.next == null) {
                return -1;
            }
            this.pos = 0;
            this.curr_read = this.curr_read.next;
        }
        --this.remaining;
        return this.curr_read.data[this.pos++] & 0xFF;
    }
}

