/* -*- mode: c++; coding: sjis-dos; -*-
 * Time-stamp: <2003-06-07 21:59:35 tfuruka1>
 * Copyright (C) 2003 Tadamegu Furukawa
 *
 * gdiɊ֘A֐ - ۂɂ̓tHg݂ĂȂEEE
 *
 * $Id: gdi_wrap.c,v 1.1 2004/01/19 09:01:28 tfuruka1 Exp $
 * $Log: gdi_wrap.c,v $
 * Revision 1.1  2004/01/19 09:01:28  tfuruka1
 * rWǗRCSCVS֕ύX܂B
 *
 * Revision 1.3  2003/06/08 11:22:10  tfuruka1
 * tHg񋓂֐ǉB
 *
 * Revision 1.2  2003/06/05 13:50:40  tfuruka1
 *  -c IvVŕł悤ɏCɔCB
 *  tHgŎΆA{[hÂ܂ܔf悤ɏCB
 *
 * Revision 1.1  2003/06/01 08:22:11  tfuruka1
 * Initial revision
 *
 */

#include "jbanner.h"

/*
 * SDK32:R\[EBhẼnh擾
 *
 * {֐͈ȉ̋LQlɂč쐬܂B
 *
 * ŏIXV: 1999/02/09
 * ԍ: J046738  
 * 
 * ͈̎ȉɂċLq̂łB
 * 
 * Microsoft(R) Win32(R) Software Development Kit (SDK)
 * 
 * ̎́Ač Microsoft Corporation 񋟂Ă Knowledge
 * Base  Article ID Q124103 (ŏIXV 1988-12-23) Ƃɍ쐬
 * ̂łB
 */
#define MY_BUFSIZE 1024                         // R\[̃^Cgp
HWND GetConsoleHwnd(VOID)
{
    HWND hwndFound;
    char pszNewWindowTitle[MY_BUFSIZE];
    char pszOldWindowTitle[MY_BUFSIZE];
    int i;

    // R\[^Cg̎擾
    GetConsoleTitle(pszOldWindowTitle, MY_BUFSIZE);

    // ƎɁAEBhE̐VK^CgtH[}bg܂
    wsprintf(pszNewWindowTitle,"%d/%d-%s",
             GetTickCount(),
             GetCurrentProcessId(),
             pszOldWindowTitle);

    // ݂̃EBhE^CgύX܂
    SetConsoleTitle(pszNewWindowTitle);

    for (i = 0; i < 100; i++) {
        // EBhE̐VK^CgTɂ܂
        hwndFound = FindWindow(NULL, pszNewWindowTitle);
        if (hwndFound) {
            Syslogger(FALSE, "GetConsoleHwnd(): =%d, T=%s",
                      i, pszNewWindowTitle);
            break;                              // 
        }
        Sleep(10);                              // 10m Wait
    }

    // ̃EBhE^Cg֖߂܂
    SetConsoleTitle(pszOldWindowTitle);

    return hwndFound;
}


/*
 * tHg֘Ȁi`BɂBC++ŃNX
 * ȁ`j
 */
static LOGFONT lft = {-13, 0, 0, 0, 800, 0, 0, 0, SHIFTJIS_CHARSET,
                      3, 2, 1, 49, TEXT("lr SVbN")};
static int numCallBack = 0;
static int CALLBACK
EnumFontFamProc(
    ENUMLOGFONT FAR *lpelf,             // pointer to logical-font data
    NEWTEXTMETRIC FAR *lpntm,           // pointer to physical-font data
    int FontType,                       // type of font
    LPARAM lParam                       // address of application-defined data
    )
{
    // f[^݂Ȃꍇ͏Ȃ
    if (!lpelf) {
        return 0;
    }

    // ------------------------------
    // tHg̍쐬v̏ꍇ̏
    // ------------------------------
    if (0 == lParam) {
        // ŏȊǑĂяȍꍇ͏Ȃ
        if (numCallBack) {
            return 0;
        }
        numCallBack++;

        Syslogger(FALSE, "ItHgt@~: %s, %s",
                  lpelf->elfFullName,
                  (FontType == DEVICE_FONTTYPE) ? "Device-Font"
                  : ((FontType == RASTER_FONTTYPE) ? "Raster-Font"
                     : "TrueType-Font"));

        memcpy(&lft, &lpelf->elfLogFont, sizeof(LOGFONT));
    }
    else {
        // ------------------------
        // tHg̈ꗗ\̏ꍇ
        // ------------------------

        // tHg̈ӂȖO, tHg̃X^C, tHg̖̏
        // \
        printf("\"%s\"\t\"%s\"\t\"%s\"\n", lpelf->elfFullName,
               lpelf->elfStyle, lpelf->elfLogFont.lfFaceName);
    }
    return 1;
}

/*
 * tHg̈ꗗ\
 */
VOID WINAPI
LsFont(LPTSTR lpszFamily)
{
    HDC hDC = CreateDC("DISPLAY", NULL, NULL, NULL);
    EnumFontFamilies(hDC, lpszFamily, (FONTENUMPROC)EnumFontFamProc, 1);
    DeleteDC(hDC);
}
/*
 * tHgt@~ftHg̘_tHg쐬
 */
BOOL WINAPI SetLogFont(LPCTSTR lpszFamily)
{
    HDC hDC = CreateDC("DISPLAY", NULL, NULL, NULL);

    numCallBack = 0;
    EnumFontFamilies(hDC, lpszFamily, (FONTENUMPROC)EnumFontFamProc, 0);
    DeleteDC(hDC);
    return numCallBack;
}

/* 
 * tHg쐬BtHgt@~ύXɂȂꍇ́A\ 
 * SetLogFont֐Ř_tHgKv܂B
 */
static HFONT WINAPI
CreateBannerFont(int nHeight)
{

    LOGFONT lf;

    memcpy(&lf, &lft, sizeof(LOGFONT));
    lf.lfHeight = nHeight;
    lf.lfWidth = 0;

    return CreateFontIndirect(&lf);
}

/*
 * oi[`悷BȂ炩̃G[ꍇ́A0(FALSE)ԋp
 * AɏIꍇ́A0ȊO(TRUE)ԋp܂B
 */
BOOL WINAPI
DrawBanner(
    LPTSTR lpszUseChar,                         // \
    int nScreenWidth,                           // \
    int nFontSize,                              // tHgTCY
    LPTSTR lpszString,                          // \
    BOOL bDebug                                 // T:fobO
    )
{
    HWND hWnd;                                  // EChEnh
    HFONT hFont;                                // tHg
    HFONT hOldFont;                             // ÂtHg
    RECT rc;                                    // `搈
    HDC hDC;                                    // foCXReLXg
    HDC hMemDC;                                 // foCXReLXgizj
    HBITMAP hBitMap;                            // rbg}bv
    HBITMAP hOldBitmap;                         // Ârbg}bv

    BYTE szLine[MAX_WIDTH];                     // oi[̈s
    LPTSTR lpszBgChar;                          // wi̕

    int x, y, ht;                               // ƍ
    int i;                                      // ėp

    // wi̕ݒ肷
    if (!(lpszBgChar = malloc(strlen(lpszUseChar + 1)))) {
        fprintf(stderr, "̊mۂɎs[%s:%d]", __FILE__, __LINE__);
        return FALSE;
    }

    for (i = 0; (ULONG)i < strlen(lpszUseChar); i++) {
        if (isKanjiSJIS(*((LPBYTE)lpszUseChar + i))) {
            strcpy(lpszBgChar + i, Z_SPACE);
            i++;
        }
        else {
            strcpy(lpszBgChar + i, " ");
        }
    }

    // EChEnh̎擾
    if (!(hWnd = GetConsoleHwnd())) {
        fprintf(stderr, "EChEnh̎擾Ɏs܂\n");
        return FALSE;
    }

    // `搈̐ݒ
    rc.top = rc.left = 0;
    rc.right = nScreenWidth;
    rc.bottom = nFontSize * 2;                  // gƂ̈2{

    // foCXReLXg̎擾
    if (!(hDC = GetDC(hWnd))) {
        fprintf(stderr, "foCXReLXg̎擾Ɏs܂B\n");
        return FALSE;
    }

    // zfoCXReLXg쐬
    if (!(hMemDC = CreateCompatibleDC(hDC))) {
        fprintf(stderr, "%s\n",
                GetLastErrorMessage("CreateCompatibleDC",
                                    GetLastError()));
        ReleaseDC(hWnd, hDC);
        return FALSE;
    }

    // rbg}bv̍쐬
    if (!(hBitMap = CreateBitmap(nScreenWidth, rc.bottom, 1, 1, NULL))) {
        fprintf(stderr, "rbg}bv̍쐬Ɏs܂\n");
        DeleteDC(hMemDC);                       // foCXReLXg폜
        ReleaseDC(hWnd, hDC);                   // foCXReLXg̊J
        return FALSE;
    }

    // rbg}bv̑I
    if (!(hOldBitmap = SelectObject(hMemDC, hBitMap))) {
        fprintf(stderr, "rbg}bv̑IɎs܂B\n");
        DeleteDC(hMemDC);                       // foCXReLXg폜
        DeleteObject(hBitMap);                  // rbg}bv폜
        ReleaseDC(hWnd, hDC);                   // foCXReLXg̊J
        return FALSE;
    }

    // tHg̍쐬
    if (!(hFont = CreateBannerFont(-nFontSize))) {
        fprintf(stderr, "%s\n",
                GetLastErrorMessage("CreateFont", GetLastError()));
        SelectObject(hMemDC, hOldBitmap);       // rbg}bv߂
        DeleteDC(hMemDC);                       // foCXReLXg폜
        DeleteObject(hBitMap);                  // rbg}bv̍폜
        ReleaseDC(hWnd, hDC);                   // foCXReLXg̊J
        return FALSE;
    }

    // tHg̑I
    if (!(hOldFont = SelectObject(hMemDC, hFont))) {
        fprintf(stderr, "IuWFNg̑I(FONT)Ɏs܂B\n");
        DeleteObject(hFont);                    // tHg̍폜
        SelectObject(hMemDC, hOldBitmap);       // rbg}bv߂
        DeleteDC(hMemDC);                       // foCXReLXg폜
        DeleteObject(hBitMap);                  // rbg}bv̍폜
        ReleaseDC(hWnd, hDC);                   // foCXReLXgJ
        return FALSE;
    }

    // tHg̐F̐ݒ
    SetTextColor(hMemDC, RGB(255, 255, 255));
    SetBkColor(hMemDC, RGB(0, 0, 0));

    // `
    ht = DrawText(hMemDC, lpszString, -1, &rc,
                  DT_LEFT | DT_TOP | DT_SINGLELINE);

    // fobO[h̏ꍇ̓R\[ɓ]
    if (bDebug) {
        BitBlt(hDC, 0, 0, rc.right, rc.bottom, hMemDC, 0, 0, SRCCOPY);
    }

    // oi[ɕϊ
    for (y = 0; y < ht; y++) {
        szLine[0] = '\0';
        for (x = 0; x < nScreenWidth; x++) {
            strcat(szLine, (0 == GetPixel(hMemDC, x, y))
                   ? lpszBgChar : lpszUseChar);
        }
        printf("%s\n", TrimRightJa(TrimRight(szLine)));
    }

    // n
    SelectObject(hMemDC, hOldFont);             // tHg߂
    SelectObject(hMemDC, hOldBitmap);           // rbg}bv߂
    ReleaseDC(hWnd, hDC);                       // foCXReLXgJ
    DeleteObject(hFont);                        // tHg폜
    DeleteObject(hBitMap);                      // rbg}bv폜
    DeleteDC(hMemDC);                           // zDC폜

    return TRUE;
}

#if 0
int main(void)
{
    HWND hWnd = GetConsoleHwnd();
    printf("DBG:TEST:GetConsoleHwnd(): hWnd = %x\n", hWnd);
}
#endif
